package cn.com.duibaboot.ext.autoconfigure.data.redis;

import java.util.List;

import javax.annotation.Resource;

import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.data.redis.JedisClientConfigurationBuilderCustomizer;
import org.springframework.data.redis.connection.RedisClusterConfiguration;
import org.springframework.data.redis.connection.RedisSentinelConfiguration;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;

public class JedisConnectionFactoryBean implements FactoryBean<JedisConnectionFactory> {

	@Resource
	private RedisProperties redisProperties;
	@Resource
	ObjectProvider<RedisSentinelConfiguration> sentinelConfiguration;
	@Resource
	ObjectProvider<RedisClusterConfiguration> clusterConfiguration;
	@Resource
	ObjectProvider<List<JedisClientConfigurationBuilderCustomizer>> builderCustomizers;

	private String extraRedisTemplateIdPrefix;

	public JedisConnectionFactoryBean(String extraRedisTemplateIdPrefix) {
		this.extraRedisTemplateIdPrefix = extraRedisTemplateIdPrefix;
	}

	private RedisProperties getRedisProperties() {
		if(extraRedisTemplateIdPrefix == null) {
			return redisProperties;
		}else{
			return redisProperties.getExtra().get(extraRedisTemplateIdPrefix);
		}
	}

	@Override
	public JedisConnectionFactory getObject() throws Exception {
		JedisConnectionConfiguration fc = new JedisConnectionConfiguration(getRedisProperties(), sentinelConfiguration,
				clusterConfiguration, builderCustomizers);
		JedisConnectionFactory f = fc.redisConnectionFactory();
		f.afterPropertiesSet();
		return f;
	}

	@Override
	public Class<?> getObjectType() {
		return JedisConnectionFactory.class;
	}

	@Override
	public boolean isSingleton() {
		return true;
	}
}
