package cn.com.duibaboot.ext.autoconfigure.etcd;

import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Client;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;

import java.nio.charset.StandardCharsets;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

@Slf4j
@AllArgsConstructor
public class EtcdHealthIndicator extends AbstractHealthIndicator {

    private static final Logger LOGGER = LoggerFactory.getLogger(EtcdHealthIndicator.class);

    private final Client etcdClient;

    @Override
    protected void doHealthCheck(Health.Builder builder) throws Exception {
        try {
            String randomKey = UUID.randomUUID().toString();
            etcdClient.getKVClient().get(ByteSequence.from(randomKey, StandardCharsets.UTF_8)).get(5, TimeUnit.SECONDS);
            builder.up();
        } catch (Exception e) {
            LOGGER.error("EtcdHealthIndicator error ", e);
            builder.down();
        }
    }

}
