package cn.com.duibaboot.ext.autoconfigure.flowreplay.record;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 录制结果
 * Created by guoyanfei .
 * 2019-01-24 .
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class RecordResult {

    /**
     * 用例集ID
     */
    private Long usecaseSetId;

    /**
     * 是否正常结果
     */
    private boolean normal;

    /**
     * 异常信息
     */
    private String message;

    /**
     * 录制结果文件的oss地址
     */
    private String ossPath;

    /**
     * 文件大小，单位 byte
     */
    private long fileSize;

    /**
     * 录制详情文件的oss地址
     */
    private String recordDetailPath;

    /**
     * 应用日志的文件地址
     */
    private String applicationLogUrl;

    private Long startTime;

    private Long endTime;

}
