package cn.com.duibaboot.ext.autoconfigure.flowreplay.record.endpoint;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.JsonResult;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.RecordContextHolder;

import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.WriteOperation;

/**
 * 流量录制结束
 * Created by guoyanfei .
 * 2019-02-19 .
 */
@Endpoint(id="flow-record-stop")
public class RecordStopMvcEndpoint {

    @WriteOperation
    public String invoke() {
        JsonResult<String> result;
        try {
            // 结束录制
            RecordContextHolder.abnormalEnd("手动停止");
            result = JsonResult.successResult("ok");
        } catch (Exception e) {
            result = JsonResult.failedResult(e.getMessage());
        }
        return result.toJSONString();
    }

}
