package cn.com.duibaboot.ext.autoconfigure.flowreplay.replay;

import org.apache.http.*;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.HeaderGroup;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HTTP;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/**
 * 手动构造的CloseableHttpResponse，用于引流回归mock httpClient的httpResponse
 * Created by guoyanfei .
 * 2019-07-23 .
 */
public class ReplayCloseableHttpResponse implements CloseableHttpResponse {

    private final byte[]      responseBody;
    private final HeaderGroup responseHeaderGroup;
    private final StatusLine  statusLine;

    public ReplayCloseableHttpResponse(byte[] responseBody, Map<String, List<String>> headers, StatusLine statusLine) {
        this.responseBody = responseBody;
        this.statusLine = statusLine;
        this.responseHeaderGroup = new HeaderGroup();
        if (headers == null || headers.size() == 0) {
            return;
        }
        for (Map.Entry<String, List<String>> h : headers.entrySet()) {
            for (String v : h.getValue()) {
                this.responseHeaderGroup.addHeader(new BasicHeader(h.getKey(), v));
            }
        }
    }

    @Override
    public HttpEntity getEntity() {
        if (responseBody == null) {
            return new BasicHttpEntity();
        }
        ByteArrayEntity entity = new ByteArrayEntity(responseBody);
        final Header contentTypeHeader = this.getFirstHeader(HTTP.CONTENT_TYPE);
        if (contentTypeHeader != null) {
            entity.setContentType(contentTypeHeader);
        }
        final Header contentEncodingHeader = this.getFirstHeader(HTTP.CONTENT_ENCODING);
        if (contentEncodingHeader != null) {
            entity.setContentEncoding(contentEncodingHeader);
        }
        return entity;
    }

    @Override
    public HeaderIterator headerIterator() {
        return this.responseHeaderGroup.iterator();
    }

    @Override
    public HeaderIterator headerIterator(String name) {
        return this.responseHeaderGroup.iterator(name);
    }

    @Override
    public boolean containsHeader(String name) {
        return this.responseHeaderGroup.containsHeader(name);
    }

    @Override
    public Header[] getHeaders(String name) {
        return this.responseHeaderGroup.getHeaders(name);
    }

    @Override
    public Header getFirstHeader(String name) {
        return this.responseHeaderGroup.getFirstHeader(name);
    }

    @Override
    public Header getLastHeader(String name) {
        return this.responseHeaderGroup.getLastHeader(name);
    }

    @Override
    public Header[] getAllHeaders() {
        return this.responseHeaderGroup.getAllHeaders();
    }

    @Override
    public HttpParams getParams() {
        return null;
    }

    @Override
    public Locale getLocale() {
        return Locale.CHINA;
    }

    @Override
    public ProtocolVersion getProtocolVersion() {
        return statusLine.getProtocolVersion();
    }

    @Override
    public StatusLine getStatusLine() {
        return statusLine;
    }

    @Override
    public void setLocale(Locale loc) {
        // do nothing
    }

    @Override
    public void addHeader(Header header) {
        // do nothing
    }

    @Override
    public void addHeader(String name, String value) {
        // do nothing
    }

    @Override
    public void setHeader(Header header) {
        // do nothing
    }

    @Override
    public void setHeader(String name, String value) {
        // do nothing
    }

    @Override
    public void setHeaders(Header[] headers) {
        // do nothing
    }

    @Override
    public void removeHeader(Header header) {
        // do nothing
    }

    @Override
    public void removeHeaders(String name) {
        // do nothing
    }

    @Override
    public void close() throws IOException {
        // do nothing
    }

    @Override
    public void setStatusLine(StatusLine statusline) {
        // do nothing
    }

    @Override
    public void setStatusLine(ProtocolVersion ver, int code) {
        // do nothing
    }

    @Override
    public void setStatusLine(ProtocolVersion ver, int code, String reason) {
        // do nothing
    }

    @Override
    public void setStatusCode(int code) throws IllegalStateException {
        // do nothing
    }

    @Override
    public void setReasonPhrase(String reason) throws IllegalStateException {
        // do nothing
    }

    @Override
    public void setEntity(HttpEntity entity) {
        // do nothing
    }

    @Override
    public void setParams(HttpParams params) {
        // do nothing
    }
}
