package cn.com.duibaboot.ext.autoconfigure.flowreplay.span;

import cn.com.duiba.wolf.utils.UUIDUtils;
import org.aspectj.lang.reflect.MethodSignature;

import java.lang.reflect.Method;

/**
 * 自定义的span类型。
 * Created by guoyanfei .
 * 2019-05-23 .
 */
public class CustomizeFlowReplaySpan extends StandardSpan {

    private static final long serialVersionUID = -3405806286282172905L;

    /**
     * 所在类，全路径，例如：cn.com.duiba.message.service.remoteservice.RemoteSmsServiceImpl
     */
    private String typeFullPath;

    @Override
    public SpanType getSpanType() {
        return SpanType.CUSTOMIZE;
    }

    /**
     * 创建span
     * @param method
     * @param allArguments
     * @param argumentsTypes
     * @param ret
     * @return
     */
    public static CustomizeFlowReplaySpan createSpan(MethodSignature methodSignature, Object[] parameterValues, Object ret) {
        Method method = methodSignature.getMethod();
        Class<?>[] parameterTypes = method.getParameterTypes();
        String[] parameterTypeNames = null;
        if (parameterTypes.length > 0) {
            parameterTypeNames = new String[parameterTypes.length];
            for (int i = 0; i < parameterTypes.length; i++) {
                parameterTypeNames[i] = parameterTypes[i].getName();
            }
        }
        Class returnTypeClass = methodSignature.getReturnType();

        CustomizeFlowReplaySpan span = new CustomizeFlowReplaySpan();
        span.setSpanId(UUIDUtils.createUUID());
        span.setMethodName(method.getName());
        span.setParameterTypes(parameterTypeNames);
        span.setParameterValues(parameterValues);
        span.setReturnType(returnTypeClass != null ? returnTypeClass.getName() : null);
        span.setReturnValue(ret);
        span.typeFullPath = methodSignature.getDeclaringTypeName();
        return span;
    }

    public String getTypeFullPath() {
        return typeFullPath;
    }

}
