package cn.com.duibaboot.ext.autoconfigure.perftest;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.dbcp2.BasicDataSource;
import org.springframework.core.env.Environment;

/**
 * 自动根据当前是不是压测请求决定访问原始数据库或者影子库
 * Created by wenqi.huang on 2016/11/24.
 */
@Slf4j
public class PerfTestRoutingDataSourceForDbcp2 extends PerfTestRoutingDataSource<BasicDataSource> {

    public PerfTestRoutingDataSourceForDbcp2(BasicDataSource originalDataSource, Environment environment, PerfTestFootMarker perfTestFootMarker) {
        super(originalDataSource, environment, perfTestFootMarker);
    }

    @Override
    protected String getJdbcUrl(BasicDataSource originalDataSource){
        return originalDataSource.getUrl();
    }

    @Override
    protected BasicDataSource copyDataSource(String testUrl, BasicDataSource originalDataSource){
        BasicDataSource ds = new BasicDataSource();
        ds.setDriverClassName(originalDataSource.getDriverClassName());
        ds.setUrl(testUrl);
        ds.setUsername(originalDataSource.getUsername());
        ds.setPassword(originalDataSource.getPassword());
        ds.setDefaultQueryTimeout(originalDataSource.getDefaultQueryTimeout());
        ds.setInitialSize(originalDataSource.getInitialSize());
        ds.setLogAbandoned(originalDataSource.getLogAbandoned());
        ds.setMaxIdle(originalDataSource.getMaxIdle());
        ds.setMaxTotal(originalDataSource.getMaxTotal());
        ds.setMinIdle(0);//压测连接池最小空闲设为0，这样可以在没有压测行为的时候尽快释放压测连接；
        ds.setValidationQuery(originalDataSource.getValidationQuery());
        ds.setValidationQueryTimeout(originalDataSource.getValidationQueryTimeout());
        ds.setTimeBetweenEvictionRunsMillis(30000);//压测连接池每隔30秒扫描一次，清理空闲链接
        ds.setSoftMinEvictableIdleTimeMillis(30000);//清理所有空闲了30秒的压测连接，只保留minIdle个连接
        ds.setTestWhileIdle(originalDataSource.getTestWhileIdle());
        ds.setTestOnBorrow(originalDataSource.getTestOnBorrow());
        ds.setTestOnReturn(originalDataSource.getTestOnReturn());
        ds.setTestOnCreate(originalDataSource.getTestOnCreate());
        ds.setMaxWaitMillis(originalDataSource.getMaxWaitMillis());
        ds.setNumTestsPerEvictionRun(originalDataSource.getNumTestsPerEvictionRun());
        ds.setRemoveAbandonedOnBorrow(originalDataSource.getRemoveAbandonedOnBorrow());
        ds.setRemoveAbandonedOnMaintenance(originalDataSource.getRemoveAbandonedOnMaintenance());
        ds.setRemoveAbandonedTimeout(originalDataSource.getRemoveAbandonedTimeout());

        ds.setConnectionInitSqls(originalDataSource.getConnectionInitSqls());

        return ds;
    }

}
