package cn.com.duibaboot.ext.autoconfigure.perftest.jedis;

import cn.com.duiba.boot.perftest.InternalPerfTestContext;
import cn.com.duiba.boot.perftest.PerfTestContext;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.InstanceMethodsAroundInterceptor;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.MethodInterceptResult;
import redis.clients.jedis.Jedis;

import java.lang.reflect.Method;

/**
 * 拦截jedis操作，在方法执行前切换dbindex，执行后切换回
 */
public class JedisPoolMethodInterceptor implements InstanceMethodsAroundInterceptor {
    private static final Integer PERF_INDEX=1;

    @Override
    public void beforeMethod(Object objInst, Method method, Object[] allArguments,
                             Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        //do nothing
    }

    @Override
    public Object afterMethod(Object zuperCall, Object objInst, Method method, Object[] allArguments,
                              Class<?>[] argumentsTypes, Object ret) throws Throwable {
        if (InternalPerfTestContext.isCurrentInPerfTestMode() && ret instanceof Jedis) {
            String methodName = method.getName();
            if(methodName.equals("getResource")) {//只在从连接池中借出的时候设置dbIndex，不需要在归还时改回去（因为每次借出时在进入此方法之前，redis.clients.jedis.JedisFactory的activateObject方法会重置成默认dbIndex）
                PerfTestContext.debugInfo("JedisPool");
                Jedis jedis = (Jedis) ret;
                jedis.select(jedis.getDB() + PERF_INDEX);
            }
        }
        return ret;
    }

    @Override
    public void handleMethodException(Object objInst, Method method, Object[] allArguments,
                                      Class<?>[] argumentsTypes, Throwable t) {
        //do nothing
    }
}
