package cn.com.duibaboot.ext.autoconfigure.perftest.lettuce;


import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.ConstructorInterceptPoint;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.InstanceMethodsInterceptPoint;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.ClassInstanceMethodsEnhancePluginDefine;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.match.ClassMatch;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.match.HierarchyMatch;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.matcher.ElementMatcher;

import static net.bytebuddy.matcher.ElementMatchers.named;

/**
 * 拦截lettuce操作，如果是发送消息(publish)则发送到特殊channel中，以防影响正常逻辑。
 */
public class LettucePublishInstrumentation extends ClassInstanceMethodsEnhancePluginDefine {

    //sync版本的其实会调用async版本的BaseRedisAsyncCommands， 所以这里只要拦截BaseRedisAsyncCommands就好。
    private static final String ENHANCE_CLASS = "io.lettuce.core.api.async.BaseRedisAsyncCommands";
    private static final String METHOD_INTERCET_CLASS = LettucePublishMethodInterceptor.class.getName();

    @Override
    public ClassMatch enhanceClass() {
        return HierarchyMatch.byHierarchyMatch(new String[]{ENHANCE_CLASS});
    }

    @Override
    protected ConstructorInterceptPoint[] getConstructorsInterceptPoints() {
        return new ConstructorInterceptPoint[0];
    }

    @Override
    protected InstanceMethodsInterceptPoint[] getInstanceMethodsInterceptPoints() {
        return new InstanceMethodsInterceptPoint[] {
            new InstanceMethodsInterceptPoint() {
                @Override
                public ElementMatcher<MethodDescription> getMethodsMatcher() {
                    return named("publish");
                }

                @Override
                public String getMethodsInterceptor() {
                    return METHOD_INTERCET_CLASS;
                }

                @Override public boolean isOverrideArgs() {
                    return true;
                }
            }
        };
    }
}
