/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.perftest;

import cn.com.duiba.boot.perftest.PerfTestContext;
import cn.com.duiba.boot.utils.SpringEnvironmentUtils;
import cn.com.duibaboot.ext.autoconfigure.perftest.PerfTestFootMarker;
import com.netflix.hystrix.exception.HystrixBadRequestException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.core.env.Environment;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;
import org.springframework.util.Assert;

public abstract class PerfTestRoutingDataSource<DS extends DataSource>
extends AbstractRoutingDataSource
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(PerfTestRoutingDataSource.class);
    private static final String ORIGINAL_DATASOURCE = "original";
    private static final String TEST_DATASOURCE = "test";
    public static final String TEST_SCHEME_PREFIX = "perf__";
    private static final String SHADE_SCHEMA = ".shade";
    private volatile boolean hasTestDataSource = false;
    private volatile boolean testDataSourceInitted = false;
    private String originalScheme;
    private DS originalDataSource;
    private Environment environment;
    private volatile DS shadeDataSource;
    private ConcurrentMap<Object, Object> targetDataSources = new ConcurrentHashMap<Object, Object>();
    private boolean thisInitted = false;
    private ConcurrentMap<String, String> normalDbUrl2shadeUrlMap = new ConcurrentHashMap<String, String>();
    private List<String> dbShadeKeys = Collections.synchronizedList(new ArrayList());
    private PerfTestFootMarker perfTestFootMarker;

    public PerfTestRoutingDataSource(DS originalDataSource, Environment environment, PerfTestFootMarker perfTestFootMarker) {
        this.originalDataSource = originalDataSource;
        this.environment = environment;
        this.perfTestFootMarker = perfTestFootMarker;
    }

    public void afterPropertiesSet() {
        if (this.thisInitted) {
            return;
        }
        this.thisInitted = true;
        this.targetDataSources.put(ORIGINAL_DATASOURCE, this.originalDataSource);
        String originalUrl = this.getJdbcUrl(this.originalDataSource);
        this.originalScheme = this.getOriginalScheme(originalUrl);
        super.setTargetDataSources(this.targetDataSources);
        this.initShadeDbMap();
        super.afterPropertiesSet();
    }

    private void initShadeDbMap() {
        LinkedHashMap properties = SpringEnvironmentUtils.getFlatEnvironments((Environment)this.environment);
        properties.entrySet().stream().forEach(x -> {
            if (((String)x.getKey()).endsWith(SHADE_SCHEMA)) {
                String dbUrl = this.environment.getProperty(((String)x.getKey()).replace(SHADE_SCHEMA, ""));
                if (this.getJdbcUrl(this.originalDataSource).equals(dbUrl)) {
                    this.normalDbUrl2shadeUrlMap.put(dbUrl, x.getValue().toString());
                    if (!this.dbShadeKeys.contains(x.getKey())) {
                        this.dbShadeKeys.add((String)x.getKey());
                    }
                }
            }
        });
    }

    protected abstract String getJdbcUrl(DS var1);

    private DS getTestDataSource(DS originalDataSource) {
        String testUrl = (String)this.normalDbUrl2shadeUrlMap.get(this.getJdbcUrl(originalDataSource));
        if (StringUtils.isBlank((CharSequence)testUrl) && !StringUtils.isBlank((CharSequence)this.originalScheme)) {
            HashSet<String> schemes = new HashSet<String>();
            try (Connection connection = originalDataSource.getConnection();
                 Statement statement = connection.createStatement();
                 ResultSet rs = statement.executeQuery("show databases");){
                while (rs.next()) {
                    schemes.add(rs.getString(1));
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            log.info("schemes of originalScheme:{}", schemes);
            String testScheme = TEST_SCHEME_PREFIX + this.originalScheme;
            if (schemes.contains(testScheme)) {
                testUrl = this.getTestUrl(this.getJdbcUrl(originalDataSource));
            }
        }
        if (testUrl == null) {
            return null;
        }
        DS copyedDataSource = this.copyDataSource(testUrl, originalDataSource);
        return copyedDataSource;
    }

    protected abstract DS copyDataSource(String var1, DS var2);

    private String getTestUrl(String originalUrl) {
        int index = originalUrl.lastIndexOf(47);
        if (index > 0) {
            return originalUrl.substring(0, index + 1) + TEST_SCHEME_PREFIX + originalUrl.substring(index + 1, originalUrl.length());
        }
        throw new IllegalArgumentException(originalUrl + " is invalid");
    }

    private String getOriginalScheme(String originalUrl) {
        if (originalUrl.startsWith("jdbc:phoenix")) {
            return null;
        }
        int index = originalUrl.indexOf("//");
        if (index > 0) {
            originalUrl = StringUtils.substring((String)originalUrl, (int)(index + 2));
        }
        if ((index = originalUrl.indexOf(47)) > 0) {
            String schemeAfter = originalUrl.substring(index + 1, originalUrl.length());
            int index1 = schemeAfter.indexOf(63);
            if (index1 > 0) {
                return schemeAfter.substring(0, index1);
            }
            return schemeAfter;
        }
        throw new IllegalArgumentException(originalUrl + " is invalid");
    }

    protected DataSource determineTargetDataSource() {
        Assert.notNull(this.targetDataSources, (String)"DataSource router not initialized");
        Object lookupKey = this.determineCurrentLookupKey();
        DataSource dataSource = (DataSource)this.targetDataSources.get(lookupKey);
        if (dataSource == null) {
            throw new IllegalStateException("Cannot determine target DataSource for lookup key [" + lookupKey + "]");
        }
        return dataSource;
    }

    public void onEnvironmentChange(EnvironmentChangeEvent event) {
        if (event.getKeys().stream().filter(s -> s.endsWith(SHADE_SCHEMA)).count() > 0L) {
            this.initShadeDbMap();
            if (this.testDataSourceInitted) {
                this.testDataSourceInitted = false;
            }
        } else if (this.testDataSourceInitted && !this.hasTestDataSource) {
            this.testDataSourceInitted = false;
        }
    }

    protected Object determineCurrentLookupKey() {
        if (PerfTestContext.isCurrentInPerfTestMode()) {
            if (!this.testDataSourceInitted) {
                this.initTestDataSource();
            }
            if (!this.hasTestDataSource) {
                throw new HystrixBadRequestException("", (Throwable)new IllegalStateException(this.getJdbcUrl(this.originalDataSource) + "\u7684\u5f71\u5b50\u5e93\u4e0d\u5b58\u5728\uff0c\u653e\u5f03\u672c\u6b21\u8bf7\u6c42\uff08\u5982\u679c\u5728\u521b\u5efa\u5f71\u5b50\u5e93\u540e\u4ecd\u7136\u9047\u5230\u6b64\u5f02\u5e38\uff0c\u8bf7\u5728\u68f1\u955c\u8fdb\u884c\u3010\u5237\u65b0\u914d\u7f6e\u3011\u64cd\u4f5c\u540e\u518d\u8bd5\uff09"));
            }
            PerfTestContext.debugInfo((String)"PerfTest DB");
            this.perfTestFootMarker.markDb(this.getJdbcUrl(this.shadeDataSource));
            return TEST_DATASOURCE;
        }
        return ORIGINAL_DATASOURCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initTestDataSource() {
        PerfTestRoutingDataSource perfTestRoutingDataSource = this;
        synchronized (perfTestRoutingDataSource) {
            if (!this.testDataSourceInitted) {
                DS testDataSource = this.getTestDataSource(this.originalDataSource);
                if (testDataSource != null) {
                    this.hasTestDataSource = true;
                    this.shadeDataSource = testDataSource;
                    this.targetDataSources.put(TEST_DATASOURCE, testDataSource);
                    log.info("\u68c0\u6d4b\u5230\u5bf9\u6570\u636e\u5e93\uff1a{}\u7684\u538b\u6d4b\u884c\u4e3a\uff0c\u5df2\u521d\u59cb\u5316\u538b\u6d4b\u4e13\u7528\u6570\u636e\u5e93\u8fde\u63a5\u6c60", (Object)this.originalScheme);
                } else {
                    this.logger.warn((Object)(this.getJdbcUrl(this.originalDataSource) + " \u6ca1\u6709\u5bf9\u5e94\u7684\u5f71\u5b50\u6570\u636e\u5e93\uff08\u5728\u540c\u4e2a\u5e93\u4e2d\u4ee5perf__\u5f00\u5934\u7684scheme, \u6216\u8005\u6dfb\u52a0.shade\u914d\u7f6e\uff09\uff0c\u5982\u679c\u4f60\u914d\u7f6e\u4e86\uff0c\u9700\u8981\u3010\u5237\u65b0\u914d\u7f6e\u3011\u751f\u6548"));
                }
                this.testDataSourceInitted = true;
            }
        }
    }

    @Override
    public synchronized void close() throws Exception {
        if (this.targetDataSources != null) {
            for (Object object : this.targetDataSources.values()) {
                try {
                    if (object instanceof AutoCloseable) {
                        ((AutoCloseable)object).close();
                        continue;
                    }
                    log.warn("[notifyme]DataSourceClass:{} \u6ca1\u6709\u5b9e\u73b0AutoCloseable\uff0c\u65e0\u6cd5\u5173\u95ed, \u9700\u8981ext\u5b9e\u73b0\u4e4b", (Object)object.getClass().toString());
                }
                catch (Exception exception) {}
            }
        }
    }

    public DataSource getOriginalDataSource() {
        return this.originalDataSource;
    }

    public DataSource getShadeDataSource() {
        return this.shadeDataSource;
    }
}

