package cn.com.duibaboot.ext.autoconfigure.cloud.netflix.hystrix;

import com.netflix.hystrix.contrib.metrics.eventstream.HystrixMetricsStreamServlet;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * 这个类用于修复/hystrix.stream的bug：https://github.com/Netflix/Hystrix/issues/1756
 * <br/>
 * 对HttpServletResponse.PrintWriter的方法进行aop,从而进行必要的同步保护,以修复HystrixSampleSseServlet多线程往writer中写导致tomcat出错的问题。
 * <br/>
 * 等官方修复这个bug后可以去掉这个类。
 */
public class ThreadSafeHystrixMetricsStreamServlet extends HystrixMetricsStreamServlet {

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        super.doGet(request, new ThreadSafeHttpServletResponseWrapper(response));
    }

}
