package cn.com.duibaboot.ext.autoconfigure.core;

import org.springframework.context.SmartLifecycle;

/**
 * 这个类的子类会在spring容器关闭的早期被销毁（在其他所有bean开始销毁前），销毁顺序由getPhase的返回值决定，使用同一个phase的一组bean会被并发销毁。
 * 子类需要实现getPhase方法和stop的无参方法.
 */
public abstract class EarlyClose implements SmartLifecycle {
    private volatile boolean isRunning = false;
    @Override
    public boolean isAutoStartup() {
        return true;
    }

    /**
     * 多个phase相同的SmartLifecycle的stop可以并发执行，所以要在新线程中关闭
     * @param callback
     */
    @Override
    public void stop(Runnable callback) {
        isRunning = false;

        new Thread(){
            @Override
            public void run(){
                try {
                    EarlyClose.this.stop();
                }finally {
                    callback.run();
                }
            }
        }.start();
    }

    @Override
    public void start() {
        isRunning = true;
    }

    @Override
    public boolean isRunning() {
        return isRunning;
    }

}
