/*
 * Copyright 2012-2015 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package cn.com.duibaboot.ext.autoconfigure.threadpool.properties;

/**
 * Configuration properties for threadPool.
 * 线程池配置
 *
 * @author hwq
 */
public class ThreadPoolProperties{

	public static final String DEFAULT_BEAN_NAME = "executorService";

	public static final String BEAN_NAME_POSTFIX = "ExecutorService";

	/**
	 * 线程池核心大小，默认2
	 */
	private int coreSize = 2;
	/**
	 * 线程池最大线程数，默认20
	 */
	private int maxSize = 20;
	/**
	 * Queue的最大容量，默认500，如果为0则使用SynchronousQueue，否则使用ArrayBlockingQueue
	 */
	private int queueSize = 500;
	/**
	 * 优雅关闭超时时间，单位ms，默认3000ms，超时则强制关闭
	 */
	private long shutdownTimeout = 3000L;

	/**
	 * 如果提交的任务等待超过maxWaitTimeMillis阈值后才开始执行（在队列中等待过久），
	 * 则打印一条warn日志，提示可能的性能瓶颈，默认1000ms
	 */
	private int maxWaitTimeMillis = 1000;

	public int getCoreSize() {
		return coreSize;
	}

	public void setCoreSize(int coreSize) {
		this.coreSize = coreSize;
	}

	public int getMaxSize() {
		return maxSize;
	}

	public void setMaxSize(int maxSize) {
		this.maxSize = maxSize;
	}

	public int getQueueSize() {
		return queueSize;
	}

	public void setQueueSize(int queueSize) {
		this.queueSize = queueSize;
	}

	public long getShutdownTimeout() {
		return shutdownTimeout;
	}

	public void setShutdownTimeout(long shutdownTimeout) {
		this.shutdownTimeout = shutdownTimeout;
	}

	public int getMaxWaitTimeMillis() {
		return maxWaitTimeMillis;
	}

	public void setMaxWaitTimeMillis(int maxWaitTimeMillis) {
		this.maxWaitTimeMillis = maxWaitTimeMillis;
	}
}
