/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.core.utils;

import cn.com.duiba.boot.utils.NetUtils;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class HttpRequestUtils {
    protected static final String UNKNOWN = "unknown";

    private HttpRequestUtils() {
    }

    public static String getIpAddr(HttpServletRequest request) {
        String[] ips;
        int size;
        String ip = request.getHeader("x-forwarded-for");
        if (ip != null && ip.trim().length() > 0 && (size = (ips = ip.trim().split(",")).length) > 0) {
            ip = ips[0].trim();
        }
        if (HttpRequestUtils.isInvalidIp(ip)) {
            ip = request.getHeader("X-Real-IP");
        }
        if (HttpRequestUtils.isInvalidIp(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (HttpRequestUtils.isInvalidIp(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (HttpRequestUtils.isInvalidIp(ip)) {
            ip = request.getHeader("Cdn-Src-Ip");
        }
        if (HttpRequestUtils.isInvalidIp(ip)) {
            ip = request.getRemoteAddr();
        }
        if (ip != null && ip.startsWith("0:0:0:0")) {
            ip = "127.0.0.1";
        }
        return ip;
    }

    private static boolean isInvalidIp(String ip) {
        return ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip);
    }

    public static boolean isLocalRequest(HttpServletRequest request) {
        String ip = HttpRequestUtils.getIpAddr(request);
        if (!ip.equals("127.0.0.1") && !ip.equals("0:0:0:0")) {
            return false;
        }
        boolean isUrlFromLocal = false;
        try {
            URL url = new URL(request.getRequestURL().toString());
            if (url.getHost().equals("localhost") || url.getHost().equals("127.0.0.1")) {
                isUrlFromLocal = true;
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return isUrlFromLocal;
    }

    public static boolean isLanRequest(HttpServletRequest request) {
        if (StringUtils.isNotBlank((CharSequence)request.getHeader("x-forwarded-for"))) {
            return false;
        }
        String ip = HttpRequestUtils.getIpAddr(request);
        boolean isLanIp = false;
        if (ip.equals("127.0.0.1") || ip.equals("0:0:0:0") || NetUtils.isLanIp((String)ip)) {
            isLanIp = true;
        }
        if (!isLanIp) {
            return false;
        }
        boolean isUrlFromLan = false;
        try {
            URL url = new URL(request.getRequestURL().toString());
            String urlHost = url.getHost();
            if (urlHost.equals("127.0.0.1") || urlHost.equals("localhost") || NetUtils.isLanIp((String)urlHost)) {
                isUrlFromLan = true;
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return isUrlFromLan;
    }
}

