/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.web;

import cn.com.duibaboot.ext.autoconfigure.core.utils.ReactiveHttpRequestUtils;
import cn.com.duibaboot.ext.autoconfigure.web.ServerStatusHolder;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

@Order(value=-2147483648)
public class BootMonitorCheckReactiveFilter
implements WebFilter {
    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        ServerHttpRequest request = exchange.getRequest();
        String requestPath = request.getPath().pathWithinApplication().value();
        if (requestPath.equals("/monitor/check")) {
            if (!ServerStatusHolder.isInService()) {
                exchange.getResponse().setStatusCode(HttpStatus.SERVICE_UNAVAILABLE);
            }
            return ReactiveHttpRequestUtils.write(exchange.getResponse(), ServerStatusHolder.isInService() ? "OK" : "INVALID");
        }
        if (requestPath.equals("/monitor/stop")) {
            if (!ReactiveHttpRequestUtils.isLocalRequest(request)) {
                return ReactiveHttpRequestUtils.write(exchange.getResponse(), "NO PERMISSION");
            }
            ServerStatusHolder.setInService(false);
            return ReactiveHttpRequestUtils.write(exchange.getResponse(), "OK");
        }
        if (requestPath.equals("/monitor/start")) {
            if (!ReactiveHttpRequestUtils.isLocalRequest(request)) {
                return ReactiveHttpRequestUtils.write(exchange.getResponse(), "NO PERMISSION");
            }
            ServerStatusHolder.setInService(true);
            return ReactiveHttpRequestUtils.write(exchange.getResponse(), "OK");
        }
        return chain.filter(exchange);
    }
}

