/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.datasource.encrypt;

import cn.com.duibaboot.ext.autoconfigure.core.SpecifiedBeanPostProcessor;
import cn.com.duibaboot.ext.autoconfigure.core.utils.PropertyResolver;
import cn.com.duibaboot.ext.autoconfigure.datasource.DataSourceBeanDefinitionRegistryPostProcessor;
import cn.com.duibaboot.ext.autoconfigure.datasource.encrypt.DBEncryptConfig;
import cn.com.duibaboot.ext.autoconfigure.datasource.encrypt.EncryptRuleConfigurationTransformer;
import cn.com.duibaboot.ext.autoconfigure.datasource.encrypt.config.DBEncryptPolicy;
import cn.com.duibaboot.ext.autoconfigure.datasource.encrypt.config.DuibaDBEncryptProperties;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.shardingsphere.encrypt.api.EncryptRuleConfiguration;
import org.apache.shardingsphere.encrypt.api.EncryptTableRuleConfiguration;
import org.apache.shardingsphere.encrypt.api.EncryptorRuleConfiguration;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.shardingjdbc.jdbc.core.datasource.EncryptDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.Environment;

public class EncryptDataSourceSpecifiedBeanPostProcessor
implements SpecifiedBeanPostProcessor,
EnvironmentAware {
    private static final Logger log = LoggerFactory.getLogger(EncryptDataSourceSpecifiedBeanPostProcessor.class);
    private final Map<String, DBEncryptConfig> dbEncryptConfigMap = new HashMap<String, DBEncryptConfig>();
    private final EncryptRuleConfigurationTransformer encryptRuleConfigurationTransformer = new EncryptRuleConfigurationTransformer();

    public void setEnvironment(Environment environment) {
        PropertyResolver resolver = new PropertyResolver((AbstractEnvironment)environment, "duiba.db.encrypt");
        DuibaDBEncryptProperties duibaDBEncryptProperties = resolver.bindToConfig(DuibaDBEncryptProperties.class);
        if (duibaDBEncryptProperties == null) {
            return;
        }
        Map<String, EncryptorRuleConfiguration> encryptors = this.encryptRuleConfigurationTransformer.transformEncryptors(duibaDBEncryptProperties.getEncryptors());
        Map<String, DBEncryptPolicy> policies = duibaDBEncryptProperties.getPolicy();
        if (encryptors.isEmpty() || policies.isEmpty()) {
            return;
        }
        Properties defaultProps = duibaDBEncryptProperties.getProps();
        for (Map.Entry<String, DBEncryptPolicy> policyEntry : policies.entrySet()) {
            DBEncryptPolicy policy = policyEntry.getValue();
            List<String> datasources = policy.getDatasources();
            Map<String, EncryptTableRuleConfiguration> tables = this.encryptRuleConfigurationTransformer.transformTables(policy.getTables());
            if (tables.isEmpty()) continue;
            for (String ds : datasources) {
                EncryptRuleConfiguration encryptRuleConfiguration = this.encryptRuleConfigurationTransformer.transformEncryptRuleConfiguration(encryptors, tables);
                if (this.dbEncryptConfigMap.get(ds) != null) {
                    throw new IllegalArgumentException("\u6570\u636e\u5e93\u52a0\u5bc6\u914d\u7f6e\u9519\u8bef\uff0c\u540c\u4e00\u4e2a\u6570\u636e\u6e90\u4e0d\u80fd\u914d\u7f6e\u5728\u591a\u4e2a\u52a0\u5bc6\u89c4\u5219\u4e2d");
                }
                this.dbEncryptConfigMap.put(ds, new DBEncryptConfig(ds, encryptRuleConfiguration, this.mergeProps(policy.getProps(), defaultProps)));
            }
        }
    }

    public Class<DataSource> getBeanType() {
        return DataSource.class;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (this.dbEncryptConfigMap.isEmpty()) {
            return bean;
        }
        for (Map.Entry<String, DBEncryptConfig> entry : this.dbEncryptConfigMap.entrySet()) {
            String dataSourceName = entry.getKey();
            String dataSourceBeanName = DataSourceBeanDefinitionRegistryPostProcessor.normalizationDataSourceName(dataSourceName);
            if (!dataSourceBeanName.equals(beanName)) continue;
            DBEncryptConfig dbEncryptConfig = entry.getValue();
            try {
                return new EncryptDataSource((DataSource)bean, new EncryptRule(dbEncryptConfig.getEncryptRuleConfiguration()), dbEncryptConfig.getProps());
            }
            catch (SQLException e) {
                throw new BeanInitializationException("\u5305\u88c5EncryptDataSource\u5f02\u5e38", (Throwable)e);
            }
        }
        return bean;
    }

    public int getOrder() {
        return 100;
    }

    private Properties mergeProps(Properties customizeProps, Properties defaultProps) {
        if (customizeProps.isEmpty()) {
            return defaultProps;
        }
        Properties newProp = new Properties();
        newProp.putAll((Map<?, ?>)defaultProps);
        for (Map.Entry<Object, Object> entry : customizeProps.entrySet()) {
            newProp.put(entry.getKey(), entry.getValue());
        }
        return newProp;
    }
}

