/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.flowreplay.replay;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayFileComponent;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayContext;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayContextHolder;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.event.ReplayEndEvent;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.event.ReplayStartEvent;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.serializer.Hessian2Serializer;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.span.FlowReplayTrace;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;

public class ReplayTraceLoader {
    private static final Logger log = LoggerFactory.getLogger(ReplayTraceLoader.class);
    @Resource
    private FlowReplayFileComponent flowReplayFileComponent;
    private volatile Thread usecaseSetLoadThread = null;

    @EventListener(value={ReplayStartEvent.class})
    public void replayStartEventListener(ReplayStartEvent event) {
        this.usecaseSetLoadThread = new Thread(new Runnable(){

            @Override
            public void run() {
                ReplayContext context = ReplayContextHolder.getReplayContext();
                if (context == null) {
                    return;
                }
                try {
                    ReplayTraceLoader.this.loadUsecaseSet(context);
                    context.tracesLoadFinish();
                }
                catch (Exception e) {
                    log.error("\u5f15\u6d41\u56de\u5f52_\u7528\u4f8b\u96c6\u52a0\u8f7d\u5f02\u5e38_reportId_{}", (Object)context.getReportId(), (Object)e);
                    ReplayContextHolder.forceEnd();
                }
            }
        }, "DBThread-Replay-\u52a0\u8f7d\u7528\u4f8b\u96c6");
        this.usecaseSetLoadThread.start();
    }

    @EventListener(value={ReplayEndEvent.class})
    public void replayEndEventListener(ReplayEndEvent event) {
        if (this.usecaseSetLoadThread != null) {
            this.usecaseSetLoadThread.interrupt();
        }
    }

    private void loadUsecaseSet(ReplayContext context) throws IOException {
        String localReplayPath = this.flowReplayFileComponent.download(context.getUsecaseSetUrl(), "/data/flowreplay/");
        File file = new File(localReplayPath);
        try (RandomAccessFile raf = new RandomAccessFile(file, "rw");){
            raf.skipBytes(8);
            while (raf.getFilePointer() < raf.length()) {
                if (!ReplayContextHolder.isReplaying()) {
                    break;
                }
                int length = raf.readInt();
                byte[] traceBytes = new byte[length];
                for (int i = 0; i < length; ++i) {
                    traceBytes[i] = raf.readByte();
                }
                FlowReplayTrace trace = (FlowReplayTrace)Hessian2Serializer.deserialize(traceBytes);
                try {
                    context.putTrace(trace);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                if (!Thread.currentThread().isInterrupted()) continue;
                break;
            }
        }
    }
}

