/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.aop;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayErrorMsgTypeEnum;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayUtils;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayTraceContext;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.StepDiffColumn;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.span.FlowReplaySpan;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.span.FlowReplayTrace;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.span.RandomFlowReplaySpan;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.span.SpanType;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.PluginException;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.MethodInterceptResult;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.StaticMethodsAroundInterceptor;
import java.lang.reflect.Method;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.com.esotericsoftware.kryo.KryoException;

public class ReplayRandomMethodInterceptor
implements StaticMethodsAroundInterceptor {
    private static final Logger log = LoggerFactory.getLogger(ReplayRandomMethodInterceptor.class);

    private boolean canReplay(Method method, Object[] allArguments) {
        if (!FlowReplayUtils.isReplayEnv() || !ReplayTraceContext.isReplaying()) {
            return false;
        }
        return !FlowReplayUtils.isGlobalWhitelist(allArguments);
    }

    @Override
    public void beforeMethod(Class clazz, Method method, Object[] allArguments, Class<?>[] parameterTypes, MethodInterceptResult result) {
        if (!this.canReplay(method, allArguments)) {
            return;
        }
        FlowReplaySpan span = ReplayTraceContext.pollSubSpan();
        RandomFlowReplaySpan replayDetailSpan = this.createReplayDetailSpan(method, allArguments, parameterTypes, span);
        if (span == null || SpanType.RANDOM != span.getSpanType()) {
            String expert = SpanType.RANDOM.name();
            String actual = span != null ? span.getSpanType().name() : null;
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_001, expert, actual);
            throw new PluginException(ReplayTraceContext.getCompletedErrorMsg());
        }
        RandomFlowReplaySpan randomSpan = (RandomFlowReplaySpan)span;
        if (!FlowReplayUtils.isMethodEqual(randomSpan.getMethodName(), method)) {
            String expert = randomSpan.getMethodName();
            String actual = method.getName();
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_602, expert, actual);
            throw new PluginException(ReplayTraceContext.getCompletedErrorMsg());
        }
        if (!FlowReplayUtils.isArgumentsTypesEqual(randomSpan.getParameterTypes(), parameterTypes)) {
            String expert = FlowReplayUtils.stringArrayToString(randomSpan.getParameterTypes());
            String actual = FlowReplayUtils.classArrayToString(parameterTypes);
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_600, expert, actual);
            throw new PluginException(ReplayTraceContext.getCompletedErrorMsg());
        }
        try {
            Set<StepDiffColumn> stepDiffColumns = FlowReplayUtils.compareArray(ReplayTraceContext.getContextTraceId(), ReplayTraceContext.getCurrentSpanIdx(), randomSpan.getParameterValues(), allArguments);
            ReplayTraceContext.addAllStepDiffColumns(stepDiffColumns);
        }
        catch (KryoException e) {
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_603, e);
            throw new PluginException(ReplayTraceContext.getCompletedErrorMsg());
        }
        try {
            Object mockRet = randomSpan.getReturnValue();
            replayDetailSpan.setReturnValue(mockRet);
            result.defineReturnValue(mockRet);
        }
        catch (KryoException e) {
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_604, e);
            throw new PluginException(ReplayTraceContext.getCompletedErrorMsg());
        }
    }

    private RandomFlowReplaySpan createReplayDetailSpan(Method method, Object[] allArguments, Class<?>[] parameterTypes, FlowReplaySpan span) {
        RandomFlowReplaySpan replayDetailSpan = RandomFlowReplaySpan.createSpan(method, allArguments, parameterTypes, null);
        replayDetailSpan.setTraceId(FlowReplayTrace.getCurrentTraceId());
        if (span != null) {
            replayDetailSpan.setSpanId(span.getSpanId());
        }
        FlowReplayTrace.addSubSpan(replayDetailSpan);
        return replayDetailSpan;
    }

    @Override
    public Object afterMethod(Class clazz, Method method, Object[] allArguments, Class<?>[] parameterTypes, Object ret) {
        return ret;
    }

    @Override
    public void handleMethodException(Class clazz, Method method, Object[] allArguments, Class<?>[] parameterTypes, Throwable t) {
    }
}

