/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.replayer;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayErrorMsgTypeEnum;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayException;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayTraceContext;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayTraceResult;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.replayer.Replayer;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.span.FlowReplayTrace;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.span.RemoteServiceFlowReplaySpan;
import com.alibaba.fastjson.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.lang.reflect.Method;
import javax.annotation.Resource;
import org.springframework.context.ApplicationContext;
import org.springframework.util.ReflectionUtils;

public class RemoteServiceReplayer
implements Replayer {
    private static final Gson gson = new Gson();
    @Resource
    private ApplicationContext applicationContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReplayTraceResult replay(FlowReplayTrace trace) {
        RemoteServiceFlowReplaySpan span = (RemoteServiceFlowReplaySpan)trace.getMainSpan();
        Object obj = this.applicationContext.getBean(RemoteServiceReplayer.toLowerCaseFirstOne(span.getTypeName()));
        FlowReplayTrace.cleanRecordEnv();
        RemoteServiceFlowReplaySpan mainSpan = RemoteServiceFlowReplaySpan.createSpan(span);
        FlowReplayTrace.createReplayTrace(mainSpan, trace.getTraceId());
        ReplayTraceContext.create(trace, FlowReplayTrace.get());
        ReplayTraceContext context = null;
        Object replayResultValue = null;
        try {
            String[] parameterTypes = span.getParameterTypes();
            int parameterLength = parameterTypes.length;
            Class[] parameterTypeClasses = null;
            if (parameterLength > 0) {
                parameterTypeClasses = new Class[parameterLength];
                for (int i = 0; i < parameterLength; ++i) {
                    parameterTypeClasses[i] = this.transformClass(parameterTypes[i]);
                }
            }
            Method method = ReflectionUtils.findMethod(obj.getClass(), (String)span.getMethodName(), (Class[])parameterTypeClasses);
            replayResultValue = ReflectionUtils.invokeMethod((Method)method, (Object)obj, (Object[])span.getParameterValues());
        }
        catch (ClassNotFoundException e) {
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_300, e);
        }
        finally {
            context = ReplayTraceContext.getAndRemove();
        }
        if (context == null) {
            throw new FlowReplayException("\u5355\u4e2a\u7528\u4f8b\u56de\u5f52\u4e0a\u4e0b\u6587\u4e22\u5931_traceId=" + trace.getTraceId());
        }
        if (context.isErrorMarked()) {
            return ReplayTraceResult.failResult(trace, context.getReplayDetailTrace(), context.getErrorMsgType(), context.getErrorMsgDetail(), context.getStepDiffColumns());
        }
        JsonElement pTemp = gson.toJsonTree(replayResultValue);
        Object replayResultValueJson = JSON.parse((String)pTemp.toString());
        mainSpan.setReturnValue(replayResultValueJson);
        return ReplayTraceResult.successResult(trace, context.getReplayDetailTrace(), replayResultValueJson, context.getStepDiffColumns());
    }

    private Class<?> transformClass(String type) throws ClassNotFoundException {
        switch (type) {
            case "long": {
                return Long.TYPE;
            }
            case "int": {
                return Integer.TYPE;
            }
            case "short": {
                return Short.TYPE;
            }
            case "float": {
                return Float.TYPE;
            }
            case "double": {
                return Double.TYPE;
            }
            case "boolean": {
                return Boolean.TYPE;
            }
            case "char": {
                return Character.TYPE;
            }
            case "byte": {
                return Byte.TYPE;
            }
        }
        return Class.forName(type);
    }

    private static String toLowerCaseFirstOne(String s) {
        if (Character.isLowerCase(s.charAt(0))) {
            return s;
        }
        return Character.toLowerCase(s.charAt(0)) + s.substring(1);
    }
}

