/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.perftest.lettuce;

import cn.com.duiba.boot.perftest.InternalPerfTestContext;
import cn.com.duibaboot.ext.autoconfigure.core.SpecifiedBeanPostProcessor;
import cn.com.duibaboot.ext.autoconfigure.perftest.lettuce.CustomLettuceConnectionFactory;
import io.lettuce.core.resource.ClientResources;
import io.lettuce.core.resource.DefaultClientResources;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.BeansException;
import org.springframework.data.redis.connection.RedisPassword;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceClientConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettucePoolingClientConfiguration;

public class LettuceConnectionFactoryBeanPostProcessor
implements SpecifiedBeanPostProcessor<LettuceConnectionFactory> {
    @Override
    public Class<LettuceConnectionFactory> getBeanType() {
        return LettuceConnectionFactory.class;
    }

    @Override
    public Object postProcessBeforeInitialization(LettuceConnectionFactory bean, String beanName) throws BeansException {
        LettuceConnectionFactory normalBean = bean;
        LettuceConnectionFactory perfTestBean = this.getPerfTestBean(normalBean);
        perfTestBean.setDatabase(normalBean.getDatabase() + 1);
        ProxyFactory factory = new ProxyFactory();
        factory.setTarget((Object)normalBean);
        factory.addAdvice((Advice)new LettuceConnectionFactoryMethodInterceptor(normalBean, perfTestBean));
        return (LettuceConnectionFactory)factory.getProxy();
    }

    private LettuceConnectionFactory getPerfTestBean(LettuceConnectionFactory normalBean) {
        RedisStandaloneConfiguration config = new RedisStandaloneConfiguration();
        config.setHostName(normalBean.getHostName());
        config.setPort(normalBean.getPort());
        config.setPassword(RedisPassword.of((String)normalBean.getPassword()));
        config.setDatabase(normalBean.getDatabase());
        DefaultClientResources clientResources = DefaultClientResources.create();
        GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
        poolConfig.setMaxTotal(8);
        poolConfig.setMinIdle(1);
        poolConfig.setMaxIdle(8);
        poolConfig.setMaxWaitMillis(100L);
        poolConfig.setTestWhileIdle(true);
        poolConfig.setTimeBetweenEvictionRunsMillis(180000L);
        LettucePoolingClientConfiguration lettucePoolingClientConfiguration = LettucePoolingClientConfiguration.builder().poolConfig(poolConfig).clientResources((ClientResources)clientResources).commandTimeout(normalBean.getClientConfiguration().getCommandTimeout()).shutdownTimeout(normalBean.getClientConfiguration().getShutdownTimeout()).build();
        CustomLettuceConnectionFactory perfTestBean = new CustomLettuceConnectionFactory(config, (LettuceClientConfiguration)lettucePoolingClientConfiguration);
        perfTestBean.setConvertPipelineAndTxResults(normalBean.getConvertPipelineAndTxResults());
        perfTestBean.setShareNativeConnection(normalBean.getShareNativeConnection());
        perfTestBean.setValidateConnection(normalBean.getValidateConnection());
        return perfTestBean;
    }

    @Override
    public Object postProcessAfterInitialization(LettuceConnectionFactory bean, String beanName) throws BeansException {
        return bean;
    }

    public int getOrder() {
        return 0;
    }

    private class LettuceConnectionFactoryMethodInterceptor
    implements MethodInterceptor {
        private LettuceConnectionFactory normalBean;
        private LettuceConnectionFactory perfTestBean;

        LettuceConnectionFactoryMethodInterceptor(LettuceConnectionFactory normalBean, LettuceConnectionFactory perfTestBean) {
            this.normalBean = normalBean;
            this.perfTestBean = perfTestBean;
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            String methodName = invocation.getMethod().getName();
            if (methodName.equals("afterPropertiesSet")) {
                this.perfTestBean.afterPropertiesSet();
                return invocation.proceed();
            }
            if (methodName.equals("destroy")) {
                this.perfTestBean.destroy();
                return invocation.proceed();
            }
            if (!InternalPerfTestContext.isCurrentInPerfTestMode()) {
                return invocation.proceed();
            }
            return invocation.getMethod().invoke((Object)this.perfTestBean, invocation.getArguments());
        }
    }
}

