/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.actuate;

import cn.com.duiba.boot.utils.RequestUtils;
import cn.com.duiba.wolf.perf.timeprofile.RequestTool;
import cn.com.duibaboot.ext.autoconfigure.core.utils.HttpRequestUtils;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class CustomMvcEndpointSecurityInterceptor
extends HandlerInterceptorAdapter {
    private static final Logger logger = LoggerFactory.getLogger(CustomMvcEndpointSecurityInterceptor.class);

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        return CustomMvcEndpointSecurityInterceptor.canContinue(request, response);
    }

    public static boolean canContinue(HttpServletRequest request, HttpServletResponse response) throws IOException {
        boolean isLanReq = HttpRequestUtils.isLanRequest(request);
        if (!isLanReq) {
            CustomMvcEndpointSecurityInterceptor.customSendFailureResponse(request, response);
        }
        return isLanReq;
    }

    private static void customSendFailureResponse(HttpServletRequest request, HttpServletResponse response) throws IOException {
        CustomMvcEndpointSecurityInterceptor.logUnauthorizedAttempt(request);
        response.sendError(HttpStatus.FORBIDDEN.value(), "Access is denied. ");
    }

    private static void logUnauthorizedAttempt(HttpServletRequest request) {
        logger.warn("Someone from internet[ip:{}] try to access actuator endpoints:[{}], Deny this request", (Object)RequestTool.getIpAddr((HttpServletRequest)request), (Object)RequestUtils.getRequestPath((HttpServletRequest)request));
    }
}

