/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.data.redis;

import cn.com.duiba.wolf.cache.Hessian2SerializationRedisSerializer;
import com.alibaba.fastjson.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.endpoint.web.annotation.ControllerEndpoint;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerEndpoint(id="hessian2RedisDeserialize")
public class Hessian2RedisDeserializeMvcEndpoint {
    private static final Logger log = LoggerFactory.getLogger(Hessian2RedisDeserializeMvcEndpoint.class);
    private RedisSerializer<Object> valueRedisSerializer = new Hessian2SerializationRedisSerializer();

    @ResponseBody
    @RequestMapping(method={RequestMethod.POST})
    public String invoke(@RequestBody byte[] data) {
        JSONObject redisValueJson = new JSONObject();
        try {
            Object value = this.valueRedisSerializer.deserialize(data);
            redisValueJson.put("redisValue", value);
            redisValueJson.put("deserializeSuccess", (Object)true);
        }
        catch (Exception e) {
            log.debug("Hessian2Redis\u53cd\u5e8f\u5217\u5316\u5f02\u5e38", (Throwable)e);
            redisValueJson.put("message", (Object)e.getMessage());
            redisValueJson.put("deserializeSuccess", (Object)false);
        }
        return redisValueJson.toJSONString();
    }
}

