package cn.com.duibaboot.ext.autoconfigure.accesslog;

import cn.com.duiba.boot.perftest.ReactivePerfTestUtils;
import cn.com.duibaboot.ext.autoconfigure.core.utils.ReactiveHttpRequestUtils;
import org.springframework.http.HttpCookie;
import org.springframework.http.ResponseCookie;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.MultiValueMap;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

import java.util.*;

/**
 * for reactive/webflux
 * Created by hwq
 */
public class AccessLogReactiveFilter extends AbstractAccessLogFilter<ServerWebExchange, ServerHttpResponse> implements WebFilter {

    @Override
    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        exchange.getRequest();
        long start = System.currentTimeMillis();
        doBefore(exchange, exchange.getResponse());

        return chain.filter(exchange).then(Mono.fromRunnable(() -> {
            doAfter(exchange, exchange.getResponse(), System.currentTimeMillis() - start);
        }));
    }

    @Override
    protected String getRequestURI(ServerWebExchange req) {
        return req.getRequest().getURI().getPath();
    }

    @Override
    protected String getMethod(ServerWebExchange req) {
        return req.getRequest().getMethodValue();
    }

    @Override
    protected String getQueryString(ServerWebExchange req) {
        return req.getRequest().getURI().getQuery();
    }

    @Override
    protected String getHeader(ServerWebExchange req, String key) {
        return req.getRequest().getHeaders().getFirst(key);
    }

    @Override
    protected String getIpAddr(ServerWebExchange req) {
        return ReactiveHttpRequestUtils.getIpAddr(req.getRequest());
    }

    @Override
    protected void addAttribute(ServerWebExchange req, String key, Object value) {
        req.getAttributes().put(key, value);
    }

    @Override
    protected Object getAttribute(ServerWebExchange req, String key) {
        return req.getAttribute(key);
    }

    @Override
    protected String getParameter(ServerWebExchange req, String key) {
        return req.getRequest().getQueryParams().getFirst(key);
    }

    @Override
    protected List<String> getParameterNames(ServerWebExchange req) {
        MultiValueMap<String, String> map = req.getRequest().getQueryParams();
        return new ArrayList<>(map.keySet());
    }

    @Override
    protected int getStatus(ServerHttpResponse resp) {
        return resp.getStatusCode() == null ? 200 : resp.getStatusCode().value();
    }

    @Override
    protected void addCookie(ServerHttpResponse resp, String key, String value, String domain, String path) {
        ResponseCookie.ResponseCookieBuilder cookieBuilder = ResponseCookie.from(key, value);

        if(domain != null) {
            cookieBuilder.domain(domain);
        }
        if(path != null) {
            cookieBuilder.path(path);
        }
        resp.addCookie(cookieBuilder.build());
    }

    @Override
    protected boolean isPerfTestRequest(ServerWebExchange req) {
        return ReactivePerfTestUtils.isPerfTestRequest(req.getRequest());
    }

    @Override
    protected Map<String, String> getCookieMap(ServerWebExchange req) {
        Map<String, String> ret = new HashMap<>();
        MultiValueMap<String, HttpCookie> map = req.getRequest().getCookies();

        map.forEach((s, httpCookies) -> {
            ret.put(s, httpCookies.get(httpCookies.size() - 1).getValue());
        });

        return ret;
    }

    protected void ensureSafeCall(){    // NOSONAR
    }
}
