package cn.com.duibaboot.ext.autoconfigure.core.utils;

import cn.com.duiba.boot.utils.NetUtils;
import org.apache.commons.lang3.StringUtils;

import javax.servlet.http.HttpServletRequest;
import java.net.MalformedURLException;
import java.net.URL;

public class HttpRequestUtils {
    private HttpRequestUtils(){}

    protected static final String UNKNOWN = "unknown";

    /**
     * 获取用户的ip地址
     * @param request
     * @return
     */
    public static String getIpAddr(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip != null && ip.trim().length() > 0) {
            String[] ips = ip.trim().split(",");
            int size = ips.length;
            if (size > 0) {
                ip = ips[0].trim();
            }
        }
        if (isInvalidIp(ip)) {
            ip = request.getHeader("X-Real-IP");
        }
        if (isInvalidIp(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (isInvalidIp(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (isInvalidIp(ip)) {
            ip = request.getHeader("Cdn-Src-Ip");
        }
        if (isInvalidIp(ip)) {
            ip = request.getRemoteAddr();
        }
        if (ip != null && ip.startsWith("0:0:0:0")) {
            ip = "127.0.0.1";//NOSONAR
        }
        return ip;
    }

    private static boolean isInvalidIp(String ip){
        return ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip);
    }

    /**
     * 访问的来源ip必须是127.0.0.1， 并且访问的url也必须是127.0.0.1
     * @param request
     * @return
     */
    public static boolean isLocalRequest(HttpServletRequest request){
        String ip = getIpAddr(request);
        if (!ip.equals("127.0.0.1") && !ip.equals("0:0:0:0")) {//NOSONAR
            return false;
        }

        //ip有可能是伪造的，故需要结合host一起判断
        boolean isUrlFromLocal = false;
        try {
            URL url = new URL(request.getRequestURL().toString());
            if(url.getHost().equals("localhost") || url.getHost().equals("127.0.0.1")) {//NOSONAR
                isUrlFromLocal = true;
            }
        } catch (MalformedURLException e) {
            // Ignore
        }

        return isUrlFromLocal;
    }

    /**
     * 访问的来源ip必须在内网，并且没有经过代理
     * @param request
     * @return
     */
    public static boolean isLanRequest(HttpServletRequest request){
        if(StringUtils.isNotBlank(request.getHeader("x-forwarded-for"))){
            // 有x-forwarded-for字段表示来自代理。
            return false;
        }
        String ip = getIpAddr(request);
        boolean isLanIp = false;
        if (ip.equals("127.0.0.1") || ip.equals("0:0:0:0") || NetUtils.isLanIp(ip)) {//NOSONAR
            isLanIp = true;
        }
        if(!isLanIp){
            return false;
        }

        //ip有可能是伪造的，故需要结合host一起判断
        boolean isUrlFromLan = false;
        try {
            URL url = new URL(request.getRequestURL().toString());
            String urlHost = url.getHost();
            if (urlHost.equals("127.0.0.1") || urlHost.equals("localhost") || NetUtils.isLanIp(urlHost)) {//NOSONAR
                isUrlFromLan = true;
            }
        } catch (MalformedURLException e) {
            // Ignore
        }

        return isUrlFromLan;
    }

}
