package cn.com.duibaboot.ext.autoconfigure.batch;

import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix = "duiba.merge.request")
public class BatchProperties {

    /**
     * 是否启用
     */
    private boolean enable = false;

    /**
     * 处理任务的线程池大小
     */
    private int poolsize = 50;

    /**
     * 批量处理个数
     */
    private int batchsize = 30;

    /**
     * 队列最大阀值
     */
    private int maxqueue = 10000;

    public boolean isEnable() {
        return enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public int getPoolsize() {
        return poolsize;
    }

    public void setPoolsize(int poolsize) {
        this.poolsize = poolsize;
    }

    public int getBatchsize() {
        return batchsize;
    }

    public void setBatchsize(int batchsize) {
        this.batchsize = batchsize;
    }

    public int getMaxqueue() {
        return maxqueue;
    }

    public void setMaxqueue(int maxqueue) {
        this.maxqueue = maxqueue;
    }
}
