package cn.com.duibaboot.ext.autoconfigure.cloud.netflix.eureka;

import cn.com.duiba.boot.utils.AopTargetUtils;
import com.google.common.base.Throwables;
import com.netflix.discovery.DiscoveryClient;
import com.netflix.discovery.EurekaClient;
import org.springframework.util.ReflectionUtils;

import java.lang.reflect.Method;

public class EurekaClientUtils {

    private static final Method refreshRegistryMethod = ReflectionUtils.findMethod(DiscoveryClient.class, "refreshRegistry");

    static{
        refreshRegistryMethod.setAccessible(true);
    }

    private EurekaClientUtils(){}

    /**
     * 调用discoveryClient.refreshRegistry方法来触发刷新本地的服务器列表（会重新获取注册到eureka上的所有服务器）。
     * @param eurekaClient
     */
    public static void refreshRegistry(EurekaClient eurekaClient){
        //调用discoveryClient.refreshRegistry方法来触发刷新本地的服务器列表（会获取注册到eureka上的所有服务器）。
//        if(AopUtils.isJdkDynamicProxy(eurekaClient))
        //eurekaClient可能是refreshScope的，target可能会变，所以需要每次重新获取
        DiscoveryClient discoveryClient = null;
        try {
            discoveryClient = AopTargetUtils.getTarget(eurekaClient);
        } catch (Exception e) {
            throw Throwables.propagate(e);
        }
        ReflectionUtils.invokeMethod(refreshRegistryMethod, discoveryClient);
    }
}
