package cn.com.duibaboot.ext.autoconfigure.cloud.netflix.feign.hystrix;

import java.util.Map;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.HystrixThreadPoolProperties;
import com.netflix.hystrix.contrib.javanica.conf.HystrixPropertiesManager;
import com.netflix.hystrix.strategy.properties.HystrixPropertiesFactory;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;

/**
 * Created by hujinliang on 2018/1/22.
 */
@Endpoint(id="circuit-breaker")
public class CircuitBreakerEndpoint {
    private final Map<String,Object> circuitBreakerInfo;

    public CircuitBreakerEndpoint(Map<String,Object> circuitBreakerInfo) {
        this.circuitBreakerInfo = circuitBreakerInfo;
    }

    @ReadOperation
    public String invoke() {
        Map<String, Object> circuitBreakerMap = Maps.newHashMap(circuitBreakerInfo);
        refreshProperty(circuitBreakerMap, 0);
        return JSON.toJSONString(circuitBreakerMap);
    }

    private void refreshProperty(Map<String, Object> circuitBreakerMap, int i) {
        for (Map.Entry<String, Object> kv : circuitBreakerMap.entrySet()) {
            if (i == 2) {//应用名-线程池组名称-Command名称
                if(kv.getKey().equals(HystrixPropertiesManager.CORE_SIZE)
                        || kv.getKey().equals("maximumSize")
                        || kv.getKey().equals(HystrixPropertiesManager.MAX_QUEUE_SIZE)
                        || kv.getKey().equals(HystrixPropertiesManager.QUEUE_SIZE_REJECTION_THRESHOLD)){
                    continue;
                }
                HystrixCommandProperties commandProperties = HystrixPropertiesFactory.getCommandProperties(HystrixCommandKey.Factory.asKey(kv.getKey()), null);
                Map<String, Object> commandProperty = Maps.newHashMap();
                commandProperty.put(HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, commandProperties.executionTimeoutInMilliseconds().get());
                commandProperty.put(HystrixPropertiesManager.CIRCUIT_BREAKER_FORCE_OPEN, commandProperties.circuitBreakerForceOpen().get());
                kv.setValue(commandProperty);
            } else {
                Map<String, Object> val = (Map<String, Object>) kv.getValue();
                if (i == 1) {//应用名-线程池组名称
                    HystrixThreadPoolProperties threadProperties = HystrixPropertiesFactory.getThreadPoolProperties(HystrixThreadPoolKey.Factory.asKey(kv.getKey()), null);
                    val.put(HystrixPropertiesManager.CORE_SIZE, threadProperties.coreSize().get());
                    val.put("maximumSize", threadProperties.maximumSize().get());
                    val.put(HystrixPropertiesManager.MAX_QUEUE_SIZE, threadProperties.maxQueueSize().get());
                    val.put(HystrixPropertiesManager.QUEUE_SIZE_REJECTION_THRESHOLD, threadProperties.queueSizeRejectionThreshold().get());
                }
                int next=i+1;
                refreshProperty(val, next);
            }
        }

    }

}
