package cn.com.duibaboot.ext.autoconfigure.datasource.encrypt;

import cn.com.duibaboot.ext.autoconfigure.datasource.encrypt.config.DuibaDBEncryptProperties;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

/**
 * 数据库加密相关自动配置
 * Created by gyf .
 * 2020/7/24 .
 */
@Configuration
@EnableConfigurationProperties({ DuibaDBEncryptProperties.class })
@Conditional(DuibaDBEncryptCondition.class)
@AutoConfigureBefore(DataSourceAutoConfiguration.class)
public class EncryptDataSourceAutoConfiguration {

    /**
     * 数据源的初始化后置操作类
     * 在 DataSource 初始化结束的时候，判断如果该数据源有相关的加密配置，则通过包装的方式，把这个数据源包装到 EncryptDataSource 中
     * @return
     */
    @Bean
    public static EncryptDataSourceSpecifiedBeanPostProcessor encryptDataSourceSpecifiedBeanPostProcessor() {
        return new EncryptDataSourceSpecifiedBeanPostProcessor();
    }

}
