package cn.com.duibaboot.ext.autoconfigure.elasticjob;

import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.InstanceMethodsAroundInterceptor;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.MethodInterceptResult;

import java.lang.reflect.Method;
import java.util.Properties;

import static org.quartz.impl.StdSchedulerFactory.PROP_THREAD_EXECUTOR_CLASS;

/**
 * 修改字节码，修复elasticjob与spring-cloud不兼容的问题，elasticjob过早调用了feign，报出超时问题，这里尝试延迟到容器启动完成后再执行任务
 */
public class ElasticJobMethodInterceptor implements InstanceMethodsAroundInterceptor {

    @Override
    public void beforeMethod(Object objInst, Method method, Object[] allArguments,
                             Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        if (method.getName().equals("prepareEnvironments") && method.getParameterTypes().length == 1
                && method.getParameterTypes()[0].equals(Properties.class)) {
            Properties props = (Properties)allArguments[0];
            props.put(PROP_THREAD_EXECUTOR_CLASS, DelayedThreadExecutor.class.getName());
        }
    }

    @Override
    public Object afterMethod(Object zuperCall, Object objInst, Method method, Object[] allArguments,
                              Class<?>[] argumentsTypes, Object ret) throws Throwable {
        return ret;
    }

    @Override
    public void handleMethodException(Object objInst, Method method, Object[] allArguments,
                                      Class<?>[] argumentsTypes, Throwable t) {
        //do nothing
    }
}
