package cn.com.duibaboot.ext.autoconfigure.flowreplay.span;

import cn.com.duiba.wolf.utils.UUIDUtils;
import org.aspectj.lang.reflect.MethodSignature;

import java.lang.reflect.Method;

/**
 * Created by guoyanfei .
 * 2019-07-18 .
 */
public class RocketMqProducerFlowReplaySpan extends StandardSpan {

    private static final long serialVersionUID = 6683902243547622289L;

    /**
     * 所在类，全路径，例如：cn.com.duiba.message.service.remoteservice.RemoteSmsServiceImpl
     */
    private String typeFullPath;

    @Override
    public SpanType getSpanType() {
        return SpanType.ROCKETMQ;
    }

    public static RocketMqProducerFlowReplaySpan createSpan(MethodSignature methodSignature, Object[] parameterValues) {
        Method method = methodSignature.getMethod();
        Class<?>[] parameterTypes = method.getParameterTypes();
        String[] parameterTypeNames = null;
        if (parameterTypes.length > 0) {
            parameterTypeNames = new String[parameterTypes.length];
            for (int i = 0; i < parameterTypes.length; i++) {
                parameterTypeNames[i] = parameterTypes[i].getName();
            }
        }
        Class returnTypeClass = methodSignature.getReturnType();

        RocketMqProducerFlowReplaySpan span = new RocketMqProducerFlowReplaySpan();
        span.setSpanId(UUIDUtils.createUUID());
        span.setMethodName(method.getName());
        span.setParameterTypes(parameterTypeNames);
        span.setParameterValues(parameterValues);;
        span.setReturnType(returnTypeClass != null ? returnTypeClass.getName() : null);
        span.typeFullPath = methodSignature.getDeclaringTypeName();
        return span;
    }

    public String getTypeFullPath() {
        return typeFullPath;
    }

}
