package cn.com.duibaboot.ext.autoconfigure.logger.logback.appender;

import org.springframework.boot.context.properties.ConfigurationProperties;

import java.util.Map;

@ConfigurationProperties(prefix = "duiba.logback.appender.kafka")
public class KafkaAppenderProperties {
    private Pattern[] patterns;

    public Pattern[] getPatterns() {
        return patterns;
    }

    public void setPatterns(Pattern[] patterns) {
        this.patterns = patterns;
    }

    public static class Pattern{
        /**
         * 需要匹配的logback loggerName
         */
        private String loggerName;
        /**
         * 需要匹配的json字段（JSONPath语法），非必填；当你需要判断日志内容来决定发往哪个topic时，可以配置这个属性。配置多个的话则要求同时满足才会发往指定topic;这个配置要求你的日志内容是json字符串。
         */
        private Map<String, String> matchJson = null;
        /**
         * 匹配成功后需要发送的kafka目标topic
         */
        private String topic;
        /**
         * 缓冲队列长度，默认5120
         */
        private Integer queueSize = 5120;
        /**
         * 当缓冲队列满的时候，是否阻塞，默认为false,队列满会丢弃新消息；如果设为true，则当队列满的时候，会阻塞发送线程
         */
        private Boolean blockWhenFull = false;

        public String getLoggerName() {
            return loggerName;
        }

        public void setLoggerName(String loggerName) {
            this.loggerName = loggerName;
        }

        public String getTopic() {
            return topic;
        }

        public void setTopic(String topic) {
            this.topic = topic;
        }

        public Integer getQueueSize() {
            return queueSize;
        }

        public void setQueueSize(Integer queueSize) {
            this.queueSize = queueSize;
        }

        public Boolean getBlockWhenFull() {
            return blockWhenFull;
        }

        public void setBlockWhenFull(Boolean blockWhenFull) {
            this.blockWhenFull = blockWhenFull;
        }

        public Map<String, String> getMatchJson() {
            return matchJson;
        }

        public void setMatchJson(Map<String, String> matchJson) {
            this.matchJson = matchJson;
        }
    }
}
