package cn.com.duibaboot.ext.autoconfigure.perftest.hbase;

import java.lang.reflect.Method;

import cn.com.duiba.boot.perftest.InternalPerfTestContext;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.InstanceMethodsAroundInterceptor;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.MethodInterceptResult;
import org.apache.commons.lang3.StringUtils;

import static cn.com.duibaboot.ext.autoconfigure.perftest.PerfTestRoutingDataSource.*;

/**
 * 压测时给表换个namespace, 使用perf__开头的影子库namespace
 */
public class HbaseOperationsMethodInterceptor implements InstanceMethodsAroundInterceptor {

    @Override
    public void beforeMethod(Object objInst, Method method, Object[] allArguments,
                             Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        if (!InternalPerfTestContext.isCurrentInPerfTestMode()) {
            return;
        }

        if (method.getParameterCount() >= 1 && method.getParameterTypes()[0].equals(String.class)){
            String tableName = (String) allArguments[0];

            if (StringUtils.isBlank(tableName)) {
                return;
            }

            String[] arr = StringUtils.split(tableName, ':');
            String namespace = arr.length == 1 ? "default" : arr[0];
            String realTableName = arr.length == 1 ? arr[0] : arr[1];
            if ("hbase".equals(namespace) //系统namespace，一般是查询元数据，压测也走这个namespace。
                    || namespace.startsWith(TEST_SCHEME_PREFIX)) {
                return;
            }
            namespace = TEST_SCHEME_PREFIX + namespace;
            tableName = namespace + ":" + realTableName;

            allArguments[0] = tableName;
        }
    }

    @Override
    public Object afterMethod(Object zuperCall, Object objInst, Method method, Object[] allArguments,
                              Class<?>[] argumentsTypes, Object ret) throws Throwable {
        return ret;
    }

    @Override
    public void handleMethodException(Object objInst, Method method, Object[] allArguments,
                                      Class<?>[] argumentsTypes, Throwable t) {
        //do nothing
    }
}
