package cn.com.duibaboot.ext.autoconfigure.threadpool.proxy;

import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import com.google.common.base.Throwables;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;

import static org.slf4j.LoggerFactory.getLogger;

/**
 * 增加cat/DBTimeProfile监控耗时的功能
 */
public class ProfileCallable extends MonitorCallable {

    private static final Logger logger = getLogger(ProfileCallable.class);

    private String threadPoolName;

    public ProfileCallable(Callable callable) {
        super(callable);
    }

    public ProfileCallable(Callable callable, BlockingQueue<Runnable> queue, String threadPoolName, int maxWaitTimeMillis) {
        super(callable, queue, maxWaitTimeMillis);
        this.threadPoolName = threadPoolName;
    }

    @Override
    public Object call() throws Exception {
        DBTimeProfile.start();
        Callable callable = getRootCallable();
        String rootCallableClassName = callable.getClass().getName();
        try {
            return CatUtils.executeInCatTransaction(() -> super.call(),
                    "ThreadPool",
                    "(" + threadPoolName + ")" + rootCallableClassName);
        } catch (Throwable throwable) {
            if (nestOverLimit(throwable)) {
                throw new Exception("abnormal throwable: 【" + throwable.getClass().getName() + "】, stacktrace: 【" + ExceptionUtils.getStackTrace(throwable) + "】");
            }
            logger.error("", throwable);
            throw Throwables.propagate(throwable);
        } finally{
            DBTimeProfile.end(rootCallableClassName + ", thread:" + Thread.currentThread().getName());
        }
    }

    /**
     * 判断异常嵌套层次是否过深
     *
     * @param t
     * @return true 嵌套超过20层
     */
    private static boolean nestOverLimit(Throwable t) {
        int nestTime = 0;
        while (t != null) {
            if (nestTime > 20) {
                logger.error("detect abnormal exception:{}, msg={}", t.getClass().getName(), t.getMessage());
                return true;
            }
            t = t.getCause();
            nestTime++;
        }
        return false;
    }

}
