/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.core.utils;

import cn.com.duiba.boot.utils.NetUtils;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.apache.commons.lang3.StringUtils;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.NettyDataBuffer;
import org.springframework.core.io.buffer.NettyDataBufferFactory;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import reactor.core.publisher.Mono;

public class ReactiveHttpRequestUtils {
    private ReactiveHttpRequestUtils() {
    }

    public static String getIpAddr(ServerHttpRequest request) {
        String[] ips;
        int size;
        String ip = request.getHeaders().getFirst("x-forwarded-for");
        if (ip != null && ip.trim().length() > 0 && (size = (ips = ip.trim().split(",")).length) > 0) {
            ip = ips[0].trim();
        }
        if (ReactiveHttpRequestUtils.isInvalidIp(ip)) {
            ip = request.getHeaders().getFirst("X-Real-IP");
        }
        if (ReactiveHttpRequestUtils.isInvalidIp(ip)) {
            ip = request.getHeaders().getFirst("Proxy-Client-IP");
        }
        if (ReactiveHttpRequestUtils.isInvalidIp(ip)) {
            ip = request.getHeaders().getFirst("WL-Proxy-Client-IP");
        }
        if (ReactiveHttpRequestUtils.isInvalidIp(ip)) {
            ip = request.getHeaders().getFirst("Cdn-Src-Ip");
        }
        if (ReactiveHttpRequestUtils.isInvalidIp(ip)) {
            ip = request.getRemoteAddress().getAddress().getHostAddress();
        }
        if (ip != null && ip.startsWith("0:0:0:0")) {
            ip = "127.0.0.1";
        }
        return ip;
    }

    private static boolean isInvalidIp(String ip) {
        return ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip);
    }

    public static boolean isLocalRequest(ServerHttpRequest request) {
        String ip = ReactiveHttpRequestUtils.getIpAddr(request);
        if (!ip.equals("127.0.0.1") && !ip.equals("0:0:0:0")) {
            return false;
        }
        boolean isUrlFromLocal = false;
        String host = request.getURI().getHost();
        if (host.equals("localhost") || host.equals("127.0.0.1")) {
            isUrlFromLocal = true;
        }
        return isUrlFromLocal;
    }

    public static boolean isLanRequest(ServerHttpRequest request) {
        if (StringUtils.isNotBlank((CharSequence)request.getHeaders().getFirst("x-forwarded-for"))) {
            return false;
        }
        String ip = ReactiveHttpRequestUtils.getIpAddr(request);
        boolean isLanIp = false;
        if (ip.equals("127.0.0.1") || ip.equals("0:0:0:0") || NetUtils.isLanIp((String)ip)) {
            isLanIp = true;
        }
        if (!isLanIp) {
            return false;
        }
        boolean isUrlFromLan = false;
        String host = request.getURI().getHost();
        if (host.equals("127.0.0.1") || host.equals("localhost") || NetUtils.isLanIp((String)host)) {
            isUrlFromLan = true;
        }
        return isUrlFromLan;
    }

    public static Mono<Void> write(ServerHttpResponse response, String message) {
        ByteBuffer byteBuffer = Charset.forName("UTF-8").encode(message);
        NettyDataBufferFactory factory = (NettyDataBufferFactory)response.bufferFactory();
        NettyDataBuffer buffer = factory.wrap(byteBuffer);
        response.getHeaders().setContentLength((long)byteBuffer.remaining());
        return response.writeWith((Publisher)Mono.just((Object)buffer));
    }
}

