/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.etcd;

import cn.com.duibaboot.ext.autoconfigure.etcd.EtcdEndpoint;
import cn.com.duibaboot.ext.autoconfigure.etcd.EtcdLastRefreshStateEndpoint;
import cn.com.duibaboot.ext.autoconfigure.etcd.client.EtcdKVClientDelegate;
import cn.com.duibaboot.ext.autoconfigure.etcd.client.JetcdKVClientDelegate;
import cn.com.duibaboot.ext.autoconfigure.etcd.client.RestEtcdKVClientDelegate;
import cn.com.duibaboot.ext.autoconfigure.etcd.properties.EtcdProperties;
import io.etcd.jetcd.Client;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnEnabledEndpoint;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"duiba.cloud.etcd.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={EtcdProperties.class})
public class EtcdAutoConfiguration {

    @Configuration
    @ConditionalOnClass(value={Endpoint.class})
    protected static class EtcdHealthConfig {
        protected EtcdHealthConfig() {
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnEnabledEndpoint
        public EtcdLastRefreshStateEndpoint etcdLastRefreshStateEndpoint() {
            return new EtcdLastRefreshStateEndpoint();
        }
    }

    @Configuration
    @ConditionalOnMissingClass(value={"com.coreos.jetcd.Client"})
    public static class SimpleRestEtcdClientConfiguration {
        @Bean
        @ConditionalOnMissingBean(value={EtcdKVClientDelegate.class})
        public EtcdKVClientDelegate etcdKVClientDelegate(EtcdProperties etcdProperties) {
            String[] etcdUris = etcdProperties.getUris().toArray(new String[etcdProperties.getUris().size()]);
            return new RestEtcdKVClientDelegate(etcdUris);
        }
    }

    @Configuration
    @ConditionalOnClass(value={Client.class})
    @ConditionalOnMissingBean(value={Client.class})
    public static class JetcdConfiguration {
        @Bean
        public Client etcdClient(EtcdProperties etcdProperties) {
            return Client.builder().endpoints(etcdProperties.getUris().toArray(new String[etcdProperties.getUris().size()])).build();
        }

        @Bean
        @ConditionalOnMissingBean(value={EtcdKVClientDelegate.class})
        public EtcdKVClientDelegate etcdKVClientDelegate(Client etcdClient) {
            return new JetcdKVClientDelegate(etcdClient);
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnEnabledEndpoint
        public EtcdEndpoint etcdEndpoint(Client etcdClient, EtcdProperties etcdProperties) {
            return new EtcdEndpoint(etcdClient, etcdProperties);
        }
    }
}

