/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.aop;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayErrorMsgTypeEnum;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayException;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayUtils;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayTraceContext;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.StepDiffColumn;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.span.FlowReplaySpan;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.span.FlowReplayTrace;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.span.RocketMqProducerFlowReplaySpan;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.span.SpanType;
import java.lang.reflect.Method;
import java.util.Set;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import shaded.com.esotericsoftware.kryo.KryoException;

@Aspect
@Order
public class ReplayRocketMqProducerPlugin {
    private static final Logger log = LoggerFactory.getLogger(ReplayRocketMqProducerPlugin.class);

    @Around(value="execution(* org.apache.rocketmq.client.producer.DefaultMQProducer+.*(..))")
    public Object rocketMqProducerJoinPoint(ProceedingJoinPoint joinPoint) throws Throwable {
        String expert;
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        if (!(FlowReplayUtils.isReplayEnv() && ReplayTraceContext.isReplaying() && "send".equals(method.getName()))) {
            return joinPoint.proceed();
        }
        FlowReplaySpan span = ReplayTraceContext.pollSubSpan();
        Object[] parameterValues = joinPoint.getArgs();
        RocketMqProducerFlowReplaySpan replayDetailSpan = this.createReplayDetailSpan(signature, parameterValues, span);
        if (span == null || SpanType.ROCKETMQ != span.getSpanType()) {
            String expert2 = SpanType.ROCKETMQ.name();
            String actual = span != null ? span.getSpanType().name() : null;
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_001, expert2, actual);
            throw new FlowReplayException(ReplayTraceContext.getCompletedErrorMsg());
        }
        RocketMqProducerFlowReplaySpan rocketMqProducerSpan = (RocketMqProducerFlowReplaySpan)span;
        if (!FlowReplayUtils.isMethodEqual(rocketMqProducerSpan.getMethodName(), method)) {
            String expert3 = rocketMqProducerSpan.getMethodName();
            String actual = method.getName();
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_1001, expert3, actual);
            throw new FlowReplayException(ReplayTraceContext.getCompletedErrorMsg());
        }
        if (!FlowReplayUtils.isArgumentsTypesEqual(rocketMqProducerSpan.getParameterTypes(), method.getParameterTypes())) {
            String expert4 = FlowReplayUtils.stringArrayToString(rocketMqProducerSpan.getParameterTypes());
            String actual = FlowReplayUtils.classArrayToString(method.getParameterTypes());
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_1002, expert4, actual);
            throw new FlowReplayException(ReplayTraceContext.getCompletedErrorMsg());
        }
        try {
            Set<StepDiffColumn> stepDiffColumns = FlowReplayUtils.compareArray(ReplayTraceContext.getContextTraceId(), ReplayTraceContext.getCurrentSpanIdx(), rocketMqProducerSpan.getParameterValues(), parameterValues);
            ReplayTraceContext.addAllStepDiffColumns(stepDiffColumns);
        }
        catch (KryoException e) {
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_1006, e);
            throw new FlowReplayException(ReplayTraceContext.getCompletedErrorMsg());
        }
        if (!FlowReplayUtils.isReturnTypeEqual(rocketMqProducerSpan.getReturnType(), method.getReturnType())) {
            expert = rocketMqProducerSpan.getReturnType();
            String actual = method.getReturnType() != null ? method.getReturnType().getName() : null;
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_1004, expert, actual);
            throw new FlowReplayException(ReplayTraceContext.getCompletedErrorMsg());
        }
        if (!FlowReplayUtils.isTypeFullPathEqual(rocketMqProducerSpan.getTypeFullPath(), signature.getDeclaringTypeName())) {
            expert = rocketMqProducerSpan.getTypeFullPath();
            String actual = signature.getDeclaringTypeName();
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_1005, expert, actual);
            throw new FlowReplayException(ReplayTraceContext.getCompletedErrorMsg());
        }
        try {
            Object mockRet = rocketMqProducerSpan.getReturnValue();
            replayDetailSpan.setReturnValue(mockRet);
            return mockRet;
        }
        catch (KryoException e) {
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_1007, e);
            throw new FlowReplayException(ReplayTraceContext.getCompletedErrorMsg());
        }
    }

    private RocketMqProducerFlowReplaySpan createReplayDetailSpan(MethodSignature signature, Object[] parameterValues, FlowReplaySpan span) {
        RocketMqProducerFlowReplaySpan replayDetailSpan = RocketMqProducerFlowReplaySpan.createSpan(signature, parameterValues);
        replayDetailSpan.setTraceId(FlowReplayTrace.getCurrentTraceId());
        if (span != null) {
            replayDetailSpan.setSpanId(span.getSpanId());
        }
        FlowReplayTrace.addSubSpan(replayDetailSpan);
        return replayDetailSpan;
    }
}

