/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.perftest.filter;

import cn.com.duiba.boot.perftest.PerfTestDto;
import cn.com.duiba.boot.perftest.ReactivePerfTestUtils;
import cn.com.duibaboot.ext.autoconfigure.core.utils.ReactiveHttpRequestUtils;
import cn.com.duibaboot.ext.autoconfigure.perftest.PerfTestFootMarker;
import cn.com.duibaboot.ext.autoconfigure.perftest.filter.PerfTestRejectProperties;
import cn.com.duibaboot.ext.autoconfigure.perftest.filter.RejectedCountDto;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

@Order(value=-2147483645)
public class ReactivePerfTestFilter
implements WebFilter {
    private static final Logger log = LoggerFactory.getLogger(ReactivePerfTestFilter.class);
    @Resource
    private PerfTestRejectProperties perfTestRejectProperties;
    @Resource
    private PerfTestFootMarker perfTestFootMarker;
    private LoadingCache<String, RejectedCountDto> servicePerfTestRejectedRequestCountCache = Caffeine.newBuilder().expireAfterWrite(5L, TimeUnit.SECONDS).initialCapacity(1).maximumSize(1L).build(s -> new RejectedCountDto());

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        boolean isPerfTestMode = ReactivePerfTestUtils.isPerfTestRequest((ServerHttpRequest)exchange.getRequest());
        if (isPerfTestMode) {
            String perfTestSceneId = ReactivePerfTestUtils.getPerfTestSceneId((ServerHttpRequest)exchange.getRequest());
            boolean isTestCluster = ReactivePerfTestUtils.isPerfTestCluster((ServerHttpRequest)exchange.getRequest());
            if (StringUtils.isNotBlank((CharSequence)perfTestSceneId)) {
                HashMap<String, PerfTestDto> loadBalancerInfo = (HashMap<String, PerfTestDto>)exchange.getAttribute("_loadBalancerKeyAttr");
                if (loadBalancerInfo == null) {
                    loadBalancerInfo = new HashMap<String, PerfTestDto>();
                    exchange.getAttributes().put("_loadBalancerKeyAttr", loadBalancerInfo);
                }
                loadBalancerInfo.put("perfTestDto", new PerfTestDto(perfTestSceneId, isTestCluster));
            }
            if (this.isServerBusy()) {
                exchange.getResponse().setStatusCode(HttpStatus.TOO_MANY_REQUESTS);
                return ReactiveHttpRequestUtils.write(exchange.getResponse(), "server busy(_duibaPerf=true)");
            }
        }
        return chain.filter(exchange);
    }

    private boolean isServerBusy() {
        return false;
    }

    private boolean isCircuitBreak() {
        RejectedCountDto rejectedCountDto = (RejectedCountDto)this.servicePerfTestRejectedRequestCountCache.get((Object)"");
        if (rejectedCountDto.isCircuitBreak(this.perfTestRejectProperties.getCircuitBreakThreshold())) {
            if (!rejectedCountDto.isLogged) {
                rejectedCountDto.isLogged = true;
                log.warn("\u538b\u6d4b\u65f6\u53d1\u73b0servlet\u5bb9\u5668\u7ebf\u7a0b\u6c60\u8fc7\u4e8e\u7e41\u5fd9\uff0c\u5df2\u7194\u65ad5\u79d2\u5185\u7684\u6240\u6709\u538b\u6d4b\u8bf7\u6c42");
            }
            return true;
        }
        return false;
    }

    private void addRejectCount() {
        RejectedCountDto rejectedCountDto = (RejectedCountDto)this.servicePerfTestRejectedRequestCountCache.get((Object)"");
        rejectedCountDto.incrRejectedCount();
    }
}

