package cn.com.duibaboot.ext.autoconfigure.cloud.netflix.eureka;

import org.springframework.context.ApplicationEvent;

import java.util.Set;

/**
 * 当当前应用感兴趣的应用的实例状态发生上下线、metadata更新等动作时发出此事件
 */
public class EurekaInstanceChangedEvent extends ApplicationEvent {

    /**
     * 这些应用发生了eureka状态、元数据的变更
     */
    private Set<String> appNames;

    /**
     * Create a new ApplicationEvent.
     *
     * @param source the object on which the event initially occurred (never {@code null})
     */
    public EurekaInstanceChangedEvent(Object source, Set<String> appNames) {
        super(source);
        this.appNames = appNames;
    }

    /**
     * 获取发生了eureka状态、元数据变更的应用
     * @return
     */
    public Set<String> getAppNames() {
        return appNames;
    }
}
