package cn.com.duibaboot.ext.autoconfigure.security;


import java.io.FileDescriptor;
import java.net.InetAddress;
import java.security.AccessControlException;
import java.security.Permission;

/**
 * 子类必须集成checkPermission和checkExec、checkConnect方法
 */
public class BaseSecurityManager extends SecurityManager {

	@Override
	public void checkExec(String cmd) {
		super.checkExec(cmd);
	}

	@Override
	public void checkCreateClassLoader() {
		//允许创建ClassLoader
		//super.checkCreateClassLoader();
	}

	@Override
	public void checkRead(String file) {
		//啥都不做，允许读文件
	}
	@Override
	public void checkRead(String file, Object context) {
		//super.checkRead(file, context);
	}
	@Override
	public void checkWrite(String file) {
		//啥都不做，允许写文件
	}
	@Override
	public void checkDelete(String file) {
		//啥都不做，允许删文件
	}

	@Override
	public void checkPackageAccess(String pkg) {
		//是否允许访问指定包下的类（包括正常访问、反射）
		//super.checkPackageAccess(pkg);
	}

	@Override
	public void checkAccess(Thread t) {
		//super.checkAccess(t);
	}

	@Override
	public void checkAccess(ThreadGroup g) {
		//super.checkAccess(g);
	}

	@Override
	public void checkMemberAccess(Class<?> clazz, int which) {
		//super.checkMemberAccess(clazz, which);
		//这个写法只有jdk7可以生效，就是说jdk8中仍然能通过反射来执行shell脚本，绕过SecurityManager，目前暂时没有好办法，除非设置javaagent
		String className = clazz.getName();
		if(className.equals("java.lang.ProcessImpl") || className.equals("java.lang.UNIXProcess")
				|| className.equals("java.lang.ProcessBuilder")){
			throw new AccessControlException("not allowed to reflect access class:" + className);
		}
	}

	@Override
	public void checkPermission(Permission perm) {
		super.checkPermission(perm);
	}

	@Override
	public void checkPermission(Permission perm, Object context) {
		//super.checkPermission(perm, context);
	}

	@Override
	public void checkExit(int status) {
		//super.checkExit(status);
	}

	@Override
	public void checkLink(String lib) {
		//允许load so文件（jni）
		//super.checkLink(lib);
	}

	@Override
	public void checkRead(FileDescriptor fd) {
		//允许从System.in读取数据
		//super.checkRead(fd);
	}

	@Override
	public void checkWrite(FileDescriptor fd) {
		//允许往System.out/err写数据
		//super.checkWrite(fd);
	}

	@Override
	public void checkConnect(String host, int port) {
		super.checkConnect(host, port);
	}

	@Override
	public void checkConnect(String host, int port, Object context) {
		super.checkConnect(host, port, context);
	}

	@Override
	public void checkListen(int port) {
		//super.checkListen(port);
	}

	@Override
	public void checkAccept(String host, int port) {
		//super.checkAccept(host, port);
	}

	@Override
	public void checkMulticast(InetAddress maddr) {
		//super.checkMulticast(maddr);
	}

	@Override
	public void checkMulticast(InetAddress maddr, byte ttl) {
		//super.checkMulticast(maddr, ttl);
	}

	@Override
	public void checkPropertiesAccess() {
		//super.checkPropertiesAccess();
	}

	@Override
	public void checkPropertyAccess(String key) {
		//super.checkPropertyAccess(key);
	}

	@Override
	public void checkPackageDefinition(String pkg) {
		//super.checkPackageDefinition(pkg);
	}

	@Override
	public void checkSetFactory() {
		//super.checkSetFactory();
	}

	@Override
	public void checkSecurityAccess(String target) {
		//super.checkSecurityAccess(target);
	}

}
