package cn.com.duibaboot.ext.autoconfigure.data.redis;

import cn.com.duiba.boot.utils.PropertyUtil;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;

public final class DuibaRedisCondition extends SpringBootCondition {

    @Override
    public ConditionOutcome getMatchOutcome(final ConditionContext conditionContext, final AnnotatedTypeMetadata annotatedTypeMetadata) {
        boolean isRedisEnable = PropertyUtil.containPropertyPrefix(conditionContext.getEnvironment(), RedisProperties.REDIS_CONFIG_PREFIX);
        return isRedisEnable ? ConditionOutcome.match() : ConditionOutcome.noMatch("Can't find redis configuration in environment.");
    }
}
