package cn.com.duibaboot.ext.autoconfigure.data.redis;

import io.lettuce.core.resource.DefaultClientResources;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.data.redis.LettuceClientConfigurationBuilderCustomizer;
import org.springframework.data.redis.connection.RedisClusterConfiguration;
import org.springframework.data.redis.connection.RedisSentinelConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;

public class LettuceConnectionFactoryBean implements FactoryBean<LettuceConnectionFactory> {

	@Resource
	private RedisProperties redisProperties;
	@Resource
	ObjectProvider<RedisSentinelConfiguration> sentinelConfiguration;
	@Resource
	ObjectProvider<RedisClusterConfiguration> clusterConfiguration;
	@Resource
	ObjectProvider<List<LettuceClientConfigurationBuilderCustomizer>> builderCustomizers;

	private String extraRedisTemplateIdPrefix;

	private LettuceConnectionFactory lettuceConnectionFactory;

	public LettuceConnectionFactoryBean(String extraRedisTemplateIdPrefix) {
		this.extraRedisTemplateIdPrefix = extraRedisTemplateIdPrefix;
	}

	private RedisProperties getRedisProperties() {
		if(extraRedisTemplateIdPrefix == null) {
			return redisProperties;
		}else{
			return redisProperties.getExtra().get(extraRedisTemplateIdPrefix);
		}
	}

	@PostConstruct
	public void init() {
		LettuceConnectionConfiguration fc = new LettuceConnectionConfiguration(getRedisProperties(), sentinelConfiguration, clusterConfiguration, builderCustomizers);
		LettuceConnectionFactory f = fc.redisConnectionFactory(DefaultClientResources.create());
		f.afterPropertiesSet();
		lettuceConnectionFactory = f;
	}

	@Override
	public LettuceConnectionFactory getObject() throws Exception {
		return lettuceConnectionFactory;
	}

	@Override
	public Class<?> getObjectType() {
		return LettuceConnectionFactory.class;
	}

	@Override
	public boolean isSingleton() {
		return true;
	}

}
