package cn.com.duibaboot.ext.autoconfigure.threadpool.proxy;

import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import com.google.common.base.Throwables;
import java.util.concurrent.BlockingQueue;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;

import static org.slf4j.LoggerFactory.getLogger;

/**
 * 增加cat/DBTimeProfile监控耗时的功能
 */
public class ProfileRunnable extends MonitorRunnable {

    private static final Logger logger = getLogger(ProfileRunnable.class);

    private String threadPoolName = "undefined";

    public ProfileRunnable(Runnable runnable) {
        super(runnable);
    }

    public ProfileRunnable(Runnable runnable, BlockingQueue<Runnable> queue, String threadPoolName, int maxWaitTimeMillis) {
        super(runnable, queue, maxWaitTimeMillis);
        this.threadPoolName = threadPoolName;
    }

    @Override
    public void run() {
        DBTimeProfile.start();
        Runnable runnable = getRootRunnable();
        String rootRunnableClassName = runnable.getClass().getName();
        try {
            CatUtils.executeInCatTransaction(() -> {
                super.run();
                return null;
            }, "ThreadPool", "(" + threadPoolName + ")" + rootRunnableClassName);
        } catch (Throwable throwable) {
            if (nestOverLimit(throwable)) {
                throw new RuntimeException("abnormal throwable: 【" + throwable.getClass().getName() + "】, stacktrace: 【" + ExceptionUtils.getStackTrace(throwable) + "】");
            }
            logger.error("", throwable);
            throw Throwables.propagate(throwable);
        } finally{
            DBTimeProfile.end(rootRunnableClassName + ", thread:" + Thread.currentThread().getName());
        }
    }

    /**
     * 判断异常嵌套层次是否过深
     *
     * @param t
     * @return true 嵌套超过20层
     */
    private boolean nestOverLimit(Throwable t) {
        int nestTime = 0;
        while (t != null) {
            if (nestTime > 20) {
                logger.error("detect abnormal exception:{}, msg={}", t.getClass().getName(), t.getMessage());
                return true;
            }
            t = t.getCause();
            nestTime++;
        }
        return false;
    }
}
