package cn.com.duibaboot.ext.autoconfigure.datasource.encrypt;

import cn.com.duibaboot.ext.autoconfigure.datasource.encrypt.config.DBEncryptColumnRule;
import cn.com.duibaboot.ext.autoconfigure.datasource.encrypt.config.DBEncryptTableRule;
import cn.com.duibaboot.ext.autoconfigure.datasource.encrypt.config.DBEncryptorRule;
import org.apache.shardingsphere.encrypt.api.EncryptColumnRuleConfiguration;
import org.apache.shardingsphere.encrypt.api.EncryptRuleConfiguration;
import org.apache.shardingsphere.encrypt.api.EncryptTableRuleConfiguration;
import org.apache.shardingsphere.encrypt.api.EncryptorRuleConfiguration;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/**
 * 配置项中的配置，通过该类的方法，转换成 apache shardingsphere 的相关类的实例
 * Created by gyf .
 * 2020/8/4 .
 */
public class EncryptRuleConfigurationTransformer {

    EncryptRuleConfiguration transformEncryptRuleConfiguration(Map<String, EncryptorRuleConfiguration> encryptors, Map<String, EncryptTableRuleConfiguration> tables) {
        EncryptRuleConfiguration encryptRule = new EncryptRuleConfiguration();
        encryptRule.getEncryptors().putAll(encryptors);
        encryptRule.getTables().putAll(tables);
        return encryptRule;
    }

    Map<String, EncryptTableRuleConfiguration> transformTables(Map<String, DBEncryptTableRule> tables) {
        if (tables == null || tables.isEmpty()) {
            return Collections.emptyMap();
        }
        Map<String, EncryptTableRuleConfiguration> tablesConfig = new HashMap<>();
        for (Map.Entry<String, DBEncryptTableRule> entry : tables.entrySet()) {
            tablesConfig.put(entry.getKey(), this.transformEncryptTableRuleConfiguration(entry.getValue()));
        }
        return tablesConfig;
    }

    private EncryptTableRuleConfiguration transformEncryptTableRuleConfiguration(final DBEncryptTableRule encryptTableRuleProp) {
        EncryptTableRuleConfiguration result = new EncryptTableRuleConfiguration();
        for (Map.Entry<String, DBEncryptColumnRule> entry : encryptTableRuleProp.getColumns().entrySet()) {
            result.getColumns().put(entry.getKey(), transformEncryptColumnRulePropTransformer(entry.getValue()));
        }
        return result;
    }

    private EncryptColumnRuleConfiguration transformEncryptColumnRulePropTransformer(final DBEncryptColumnRule encryptColumnRuleProp) {
        return new EncryptColumnRuleConfiguration(encryptColumnRuleProp.getPlainColumn(), encryptColumnRuleProp.getCipherColumn(), encryptColumnRuleProp.getAssistedQueryColumn(), encryptColumnRuleProp.getEncryptor());
    }

    Map<String, EncryptorRuleConfiguration> transformEncryptors(Map<String, DBEncryptorRule> encryptors) {
        if (encryptors == null || encryptors.isEmpty()) {
            return Collections.emptyMap();
        }
        Map<String, EncryptorRuleConfiguration> encryptorsConfig = new HashMap<>();
        for (Map.Entry<String, DBEncryptorRule> entry : encryptors.entrySet()) {
            encryptorsConfig.put(entry.getKey(), this.transformEncryptorRuleConfiguration(entry.getValue()));
        }
        return encryptorsConfig;
    }

    private EncryptorRuleConfiguration transformEncryptorRuleConfiguration(final DBEncryptorRule encryptorRuleProp) {
        return new EncryptorRuleConfiguration(encryptorRuleProp.getType(), encryptorRuleProp.getProps());
    }

}
