package cn.com.duibaboot.ext.autoconfigure.devtools;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayUtils;
import org.apache.commons.io.IOUtils;
import org.springframework.boot.context.event.ApplicationStartingEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

/**
 * 设置环境变量，当开发者试图禁用devtools的restart功能时让 DevtoolsRestarter 不介入。
 */
@Order(Ordered.HIGHEST_PRECEDENCE)
public class DevToolsApplicationStartingListener implements ApplicationListener<ApplicationStartingEvent> {

    private static final String DEVTOOLS_RESTART_KEY = "spring.devtools.restart.enabled";

    @Override
    public void onApplicationEvent(ApplicationStartingEvent event) {
        //如果用户在启动脚本里使用-Dspring.devtools.restart.enabled=* 指定了，则直接返回
        if(System.getProperty(DEVTOOLS_RESTART_KEY) != null){
            return;
        }

        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream("bootstrap.properties");
        Properties properties = new Properties();
        try {
            if(in != null) {
                properties.load(in);
            }
        } catch (IOException e) {
            throw new RuntimeException("load bootstrap.properties failed", e);
        }finally{
            IOUtils.closeQuietly(in);
        }
        // 如果当前是引流回归的回归环境，那么禁用devtools的功能
        if (FlowReplayUtils.isReplayEnv()) {
            System.setProperty(DEVTOOLS_RESTART_KEY, "false");
            return;
        }
        String val = properties.getProperty(DEVTOOLS_RESTART_KEY);
        if(val != null){
            System.setProperty(DEVTOOLS_RESTART_KEY, val);
            return;
        }

        //TODO 后续考虑去掉下面两行代码以默认开启devtools的restart功能
        //如果用户没有指定，则先强制关闭devtools的restart功能。
        System.setProperty(DEVTOOLS_RESTART_KEY, "false");
    }
}
