package cn.com.duibaboot.ext.autoconfigure.grouping.dubbo;

import cn.com.duibaboot.ext.autoconfigure.grouping.ServiceGroupContext;
import cn.com.duibaboot.ext.autoconfigure.grouping.ServiceGroupUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;

/**
 * 服务分组 dubbo客户端请求过滤器
 * 判断请求上下文中是否有服务分组的key，如果有，那么把这个key加入到rpc请求的上下文中，用于透传给下游
 * Created by gyf .
 * 2020/11/10 .
 */
@Activate(group = { CommonConstants.CONSUMER })
public class ServiceGroupDubboConsumerFilter implements Filter {

    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        String groupKey = ServiceGroupContext.getCurrentGroupKey();
        if (StringUtils.isNotBlank(groupKey)) {
            RpcContext.getContext().setAttachment(ServiceGroupUtils.DUIBA_SERVICE_GROUP_KEY, groupKey);
        }
        try {
            return invoker.invoke(invocation);
        } finally {
            RpcContext.getContext().removeAttachment(ServiceGroupUtils.DUIBA_SERVICE_GROUP_KEY);
        }
    }
}
