package cn.com.duibaboot.ext.autoconfigure.selfaware;

import cn.com.duiba.wolf.spring.selfaware.SelfAware;
import cn.com.duibaboot.ext.autoconfigure.core.SpecifiedBeanPostProcessor;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * Created by wenqi.huang on 2017/2/5.
 */
@Configuration
@ConditionalOnClass({SelfAware.class})
public class SelfAwareAutoConfiguration {

    @Bean
    public static SpecifiedBeanPostProcessor selfAwareBeanPostProcessor(){
        return new SelfAwareSpecifiedBeanPostProcessor();
    }

    public static class SelfAwareSpecifiedBeanPostProcessor implements SpecifiedBeanPostProcessor<SelfAware>, ApplicationContextAware{

        private ApplicationContext applicationContext;

        @Override
        public Class<SelfAware> getBeanType() {
            return SelfAware.class;
        }

        @Override
        public Object postProcessBeforeInitialization(SelfAware bean, String beanName) throws BeansException {
            return bean;
        }

        @Override
        public Object postProcessAfterInitialization(SelfAware bean, String beanName) throws BeansException {
            if (AopUtils.isAopProxy(bean)) {
                bean.setSelf(bean);
            } else {
                bean.setSelf(applicationContext.getBean(beanName));
            }
            return bean;
        }

        @Override
        public int getOrder() {
            return 0;
        }

        @Override
        public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
            this.applicationContext = applicationContext;
        }
    }

}
