/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.batch;

import cn.com.duiba.boot.perftest.InternalPerfTestContext;
import cn.com.duibaboot.ext.autoconfigure.batch.ReqContext;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.util.ConcurrentReferenceHashMap;

public class BatchHandler {
    private static final Map<String, Method> findMethodCache = new ConcurrentReferenceHashMap(64);

    public void doBatch(String bucketId, List<ReqContext> reqs) throws Exception {
        try {
            ReqContext one = reqs.get(0);
            if (one.isCurrentInPerfTestMode()) {
                InternalPerfTestContext.markAsPerfTest((String)one.getCurrentPerfTestSceneId(), (boolean)one.isTestCluster());
            }
            Method method = this.getMethod(one);
            Object[] args = this.getArgs(one.getParams().length, reqs);
            Object obj = method.invoke(one.getTarget(), args);
            if (Void.TYPE == method.getReturnType()) {
                return;
            }
            if (obj != null) {
                List ret = (List)obj;
                if (ret.size() != reqs.size()) {
                    throw new RuntimeException("input output size not equal");
                }
                for (int i = 0; i < reqs.size(); ++i) {
                    reqs.get(i).setResult(ret.get(i));
                }
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            InternalPerfTestContext.markAsNormal();
        }
    }

    private Method getMethod(ReqContext req) throws NoSuchMethodException {
        Method[] methods;
        Method cache = findMethodCache.get(req.getFullMethodName());
        if (cache != null) {
            return cache;
        }
        for (Method m : methods = req.getTarget().getClass().getMethods()) {
            if (!m.getName().equals(req.getAnnotation().method())) continue;
            findMethodCache.put(req.getFullMethodName(), m);
            return m;
        }
        throw new NoSuchMethodException(req.getAnnotation().method());
    }

    private Object[] getArgs(int num, List<ReqContext> reqs) {
        Object[] args = new Object[num];
        for (int i = 0; i < num; ++i) {
            ArrayList<Object> param = new ArrayList<Object>(reqs.size());
            for (ReqContext req : reqs) {
                param.add(req.getParams()[i]);
            }
            args[i] = param;
        }
        return args;
    }
}

