/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cloud.netflix.hystrix;

import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import cn.com.duibaboot.ext.autoconfigure.cat.context.CatContext;
import cn.com.duibaboot.ext.autoconfigure.core.rpc.RpcContext;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import com.alibaba.ttl.TtlCallable;
import com.dianping.cat.Cat;
import com.dianping.cat.message.Transaction;
import com.netflix.hystrix.strategy.concurrency.HystrixConcurrencyStrategy;
import com.netflix.hystrix.strategy.concurrency.HystrixContextRunnable;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomHystrixConcurrencyStrategy
extends HystrixConcurrencyStrategy {
    private static final Logger logger = LoggerFactory.getLogger(CustomHystrixConcurrencyStrategy.class);

    public <T> Callable<T> wrapCallable(Callable<T> callable) {
        if (CatUtils.isCatEnabled()) {
            boolean isTimer = this.isTimer(callable);
            return new CallableWrapperWithCat((Callable)TtlCallable.get(callable), isTimer);
        }
        return new CallableWrapper((Callable)TtlCallable.get(callable));
    }

    private boolean isTimer(Callable callable) {
        try {
            Class<?> clazz = callable.getClass().getEnclosingClass();
            return clazz == HystrixContextRunnable.class;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static class CallableWrapperWithCat
    implements Callable {
        private Callable callable;
        private Long submitNanoTime;
        private boolean isTimer;
        private RpcContext rpcContext = RpcContext.getContext().clone();
        private Integer currentThreshold = DBTimeProfile.getCurrentThreshold();

        public CallableWrapperWithCat(Callable callable, boolean isTimer) {
            this.callable = callable;
            this.submitNanoTime = System.nanoTime();
            this.isTimer = isTimer;
            this.logAsyncCall(this.rpcContext);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object call() throws Exception {
            if (this.isTimer) {
                return this.callable.call();
            }
            Transaction all = Cat.newTransaction((String)"ThreadPool", (String)"hystrix.callable");
            Cat.logRemoteCallServer((Cat.Context)this.getCatContext(this.rpcContext));
            CatUtils.newCompletedTransaction("ThreadPool", "hystrix.queue.wait", this.submitNanoTime);
            Transaction call = Cat.newTransaction((String)"ThreadPool", (String)"hystrix.call");
            try {
                if (this.currentThreshold != null) {
                    DBTimeProfile.setCurrentThreshold((int)this.currentThreshold);
                }
                DBTimeProfile.start();
                if (this.rpcContext.getTargetServiceId() != null) {
                    CatContext cat_ctx = new CatContext();
                    Cat.logRemoteCallClient((Cat.Context)cat_ctx);
                    this.setCatContext(this.rpcContext, cat_ctx);
                }
                RpcContext.setContext(this.rpcContext);
                Object v = this.callable.call();
                return v;
            }
            finally {
                call.setStatus("0");
                call.complete();
                all.setStatus("0");
                all.complete();
                RpcContext.removeContext();
                DBTimeProfile.end((String)Thread.currentThread().getName());
            }
        }

        private void logAsyncCall(RpcContext rpcContext) {
            try {
                if (CatUtils.isCatEnabled() && !this.isTimer && Cat.getManager().getPeekTransaction() != null) {
                    CatContext cat_ctx = new CatContext();
                    CatUtils.logAsyncCall(cat_ctx);
                    this.setCatContext(rpcContext, cat_ctx);
                }
            }
            catch (Exception e) {
                logger.error("logAsyncCall", (Throwable)e);
            }
        }

        private Cat.Context getCatContext(RpcContext rpcContext) {
            try {
                CatContext ctx = new CatContext();
                ctx.addProperty("_catRootMessageId", rpcContext.getAttachment("_catRootMessageId"));
                ctx.addProperty("_catChildMessageId", rpcContext.getAttachment("_catChildMessageId"));
                ctx.addProperty("_catParentMessageId", rpcContext.getAttachment("_catParentMessageId"));
                return ctx;
            }
            catch (Exception e) {
                logger.error("get cat context", (Throwable)e);
                return null;
            }
        }

        private void setCatContext(RpcContext rpcContext, Cat.Context ctx) {
            try {
                rpcContext.setAttachment("_catRootMessageId", ctx.getProperty("_catRootMessageId"));
                rpcContext.setAttachment("_catChildMessageId", ctx.getProperty("_catChildMessageId"));
                rpcContext.setAttachment("_catParentMessageId", ctx.getProperty("_catParentMessageId"));
            }
            catch (Exception e) {
                logger.error("set cat Context", (Throwable)e);
            }
        }
    }

    private static class CallableWrapper
    implements Callable {
        private Callable callable;
        private RpcContext rpcContext = RpcContext.getContext().clone();
        private Integer currentThreshold = DBTimeProfile.getCurrentThreshold();

        public CallableWrapper(Callable callable) {
            this.callable = callable;
        }

        public Object call() throws Exception {
            RpcContext.setContext(this.rpcContext);
            try {
                if (this.currentThreshold != null) {
                    DBTimeProfile.setCurrentThreshold((int)this.currentThreshold);
                }
                DBTimeProfile.start();
                Object v = this.callable.call();
                return v;
            }
            finally {
                RpcContext.removeContext();
                DBTimeProfile.end((String)Thread.currentThread().getName());
            }
        }
    }
}

