/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.datasource;

import cn.com.duibaboot.ext.autoconfigure.core.utils.PropertyResolver;
import cn.com.duibaboot.ext.autoconfigure.datasource.DuibaDataSourceProperties;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.Environment;

public class DataSourceBeanDefinitionRegistryPostProcessor
implements BeanDefinitionRegistryPostProcessor,
EnvironmentAware {
    private static final Logger logger = LoggerFactory.getLogger(DataSourceBeanDefinitionRegistryPostProcessor.class);
    private static final String DATA_SOURCE_NAME_PREFIX = "DataSource";
    protected static final String DUIBA_DATA_SOURCE_CONFIG_PREFIX = "duiba.datasource";
    private DuibaDataSourceProperties duibaDataSourceProperties;

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        if (this.duibaDataSourceProperties == null) {
            return;
        }
        for (Map.Entry<String, DuibaDataSourceProperties.DataSourcePropertiesInner> entry : this.duibaDataSourceProperties.getDatasource().entrySet()) {
            String dataSourceName = entry.getKey();
            String dataSourceBeanName = DataSourceBeanDefinitionRegistryPostProcessor.normalizationDataSourceName(dataSourceName);
            DuibaDataSourceProperties.DataSourcePropertiesInner props = entry.getValue();
            BeanDefinitionBuilder bdb = props.initializeDataSourceBeanDefinitionBuilder(dataSourceName);
            if (bdb == null) {
                logger.info("[\u7edf\u4e00\u8fde\u63a5\u6c60]\u68c0\u6d4b\u5230\u6b64dataSource:[duiba.datasource.{}]\u4e0d\u5b8c\u6574\u7684\u914d\u7f6e(\u7f3a\u5c11\u5fc5\u9700\u914d\u7f6eurl)\uff0c\u5ffd\u7565\u4e4b", (Object)dataSourceName);
                continue;
            }
            AbstractBeanDefinition bd = bdb.getBeanDefinition();
            registry.registerBeanDefinition(dataSourceBeanName, (BeanDefinition)bd);
        }
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }

    public static String normalizationDataSourceName(String dataSourceName) {
        if (!dataSourceName.endsWith(DATA_SOURCE_NAME_PREFIX)) {
            dataSourceName = dataSourceName + DATA_SOURCE_NAME_PREFIX;
        }
        return dataSourceName;
    }

    public void setEnvironment(Environment environment) {
        PropertyResolver resolver = new PropertyResolver((AbstractEnvironment)environment, "duiba");
        DuibaDataSourceProperties duibaDataSourceProperties = resolver.bindToConfig(DuibaDataSourceProperties.class);
        if (duibaDataSourceProperties.getDatasource().isEmpty()) {
            return;
        }
        this.duibaDataSourceProperties = duibaDataSourceProperties;
    }
}

