package cn.com.duibaboot.ext.autoconfigure.dubbo;

import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.Adaptive;
import org.apache.dubbo.remoting.ChannelHandler;
import org.apache.dubbo.remoting.Constants;
import org.apache.dubbo.remoting.Dispatcher;

/**
 * 拷贝 dubbo 2.7.41 的 ExecutionChannelHandler 使用dubbo的spi机制来实现cat监控统计dubbo线程池的等待和执行耗时
 *
 * @author houwen
 *
 * In addition to sending all the use thread pool processing
 */

public class DuibaDispatcher implements Dispatcher {

    public static final String NAME = "duibaDispatcher";

    @Override
    public ChannelHandler dispatch(ChannelHandler handler, URL url) {
        return new DuibaChannelHandler(handler, url);
    }

}
